/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.mqttnotification;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class MqttNotifier
extends Notifier {
    private static final String CLIENT_ID = MqttNotifier.class.getSimpleName();
    private static final String DISPLAY_NAME = "MQTT Notification";
    private static final String DEFAULT_TOPIC = "jenkins/$PROJECT_URL";
    private static final String DEFAULT_MESSAGE = "$BUILD_RESULT";
    private final String brokerUrl;
    private final String topic;
    private final String message;
    private final String qos;
    private final boolean retainMessage;

    @DataBoundConstructor
    public MqttNotifier(String brokerUrl, String topic, String message, String qos, boolean retainMessage) {
        this.brokerUrl = brokerUrl;
        this.topic = topic;
        this.message = message;
        this.qos = qos;
        this.retainMessage = retainMessage;
    }

    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    public String getTopic() {
        return StringUtils.isEmpty((String)this.topic) ? DEFAULT_TOPIC : this.topic;
    }

    public String getMessage() {
        return StringUtils.isEmpty((String)this.message) ? DEFAULT_MESSAGE : this.message;
    }

    public int getQos() {
        return Integer.valueOf(this.qos);
    }

    public boolean isRetainMessage() {
        return this.retainMessage;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        PrintStream logger = listener.getLogger();
        try {
            MqttClient mqtt = new MqttClient(this.getBrokerUrl(), CLIENT_ID);
            mqtt.connect();
            mqtt.publish(this.replaceVariables(this.getTopic(), build), this.replaceVariables(this.getMessage(), build).getBytes(), this.getQos(), this.isRetainMessage());
            mqtt.disconnect();
        }
        catch (MqttException me) {
            logger.println("ERROR: Caught MqttException while configuring MQTT connection: " + me.getMessage());
            me.printStackTrace(logger);
        }
        return true;
    }

    private String replaceVariables(String rawString, AbstractBuild build) {
        String result = rawString.replaceAll("\\$PROJECT_URL", build.getProject().getUrl());
        result = result.replaceAll("\\$BUILD_RESULT", build.getResult().toString());
        if (rawString.contains("$CULPRITS")) {
            StringBuilder culprits = new StringBuilder();
            String delim = "";
            for (Object userObject : build.getCulprits()) {
                culprits.append(delim).append(userObject.toString());
                delim = ",";
            }
            result = result.replaceAll("\\$CULPRITS", culprits.toString());
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public FormValidation doCheckBrokerHost(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckBrokerPort(@QueryParameter String value) {
            return FormValidation.validatePositiveInteger((String)value);
        }

        public ListBoxModel doFillQosItems() {
            ListBoxModel items = new ListBoxModel();
            for (Qos qos : Qos.values()) {
                items.add(qos.name(), String.valueOf(qos.getValue()));
            }
            return items;
        }

        public FormValidation doTestConnection(@QueryParameter(value="brokerUrl") String brokerUrl) throws IOException, ServletException {
            try {
                MqttClient mqtt = new MqttClient(brokerUrl, CLIENT_ID);
                mqtt.connect();
                mqtt.disconnect();
                return FormValidation.ok((String)"Success");
            }
            catch (MqttException me) {
                return FormValidation.error((Throwable)me, (String)"Failed to connect");
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return MqttNotifier.DISPLAY_NAME;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Qos {
        AT_MOST_ONCE(0),
        AT_LEAST_ONCE(1),
        EXACTLY_ONCE(2);

        private int value;

        private Qos(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

