/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jbpm;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Hudson;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.queue.QueueTaskFuture;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import jenkins.plugins.jbpm.JbpmPluginLogger;
import org.drools.command.Command;
import org.drools.command.Context;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.NodeInstance;
import org.drools.runtime.process.NodeInstanceContainer;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JenkinsJobWorkItemHandler
implements WorkItemHandler {
    private static StatefulKnowledgeSession session = null;

    public static void setSession(StatefulKnowledgeSession ksession) {
        session = ksession;
    }

    public void executeWorkItem(final WorkItem workItem, WorkItemManager workItemManager) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String jobName = JenkinsJobWorkItemHandler.this.getNameFromSession(workItem);
                JbpmPluginLogger.info("Entered: " + jobName);
                Hudson h = Hudson.getInstance();
                AbstractProject ap = (AbstractProject)h.getItemByFullName(jobName, AbstractProject.class);
                List parameters = (List)workItem.getParameter("jobParameters");
                QueueTaskFuture future = parameters != null ? ap.scheduleBuild2(0, (Cause)new WorkItemCause(), new Action[]{new ParametersAction(parameters)}) : ap.scheduleBuild2(0, (Cause)new WorkItemCause());
                Result result = null;
                QueueTaskFuture queueTaskFuture = future;
                synchronized (queueTaskFuture) {
                    try {
                        future.wait();
                        result = ap.getBuilds().getLastBuild().getResult();
                    }
                    catch (InterruptedException e) {
                        result = Result.ABORTED;
                        JbpmPluginLogger.error(e.toString());
                    }
                }
                HashMap<String, Result> workItemResults = new HashMap<String, Result>();
                workItemResults.put("jobResult", result);
                session.getWorkItemManager().completeWorkItem(workItem.getId(), workItemResults);
                JbpmPluginLogger.info("Left: " + jobName + " with result " + result.toString());
            }
        }).start();
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
    }

    private String getNameFromSession(final WorkItem workItem) {
        return (String)session.execute((Command)new GenericCommand<String>(){
            private static final long serialVersionUID = 1L;

            public String execute(Context context) {
                StatefulKnowledgeSession ksession = ((KnowledgeCommandContext)context).getStatefulKnowledgesession();
                ProcessInstance processInstance = ksession.getProcessInstance(((WorkItemImpl)workItem).getProcessInstanceId());
                WorkItemNodeInstance nodeInstance = JenkinsJobWorkItemHandler.findWorkItemNodeInstance(workItem.getId(), ((WorkflowProcessInstance)processInstance).getNodeInstances());
                return nodeInstance.getNodeName();
            }
        });
    }

    private static WorkItemNodeInstance findWorkItemNodeInstance(long workItemId, Collection<NodeInstance> nodeInstances) {
        for (NodeInstance nodeInstance : nodeInstances) {
            WorkItemNodeInstance result;
            WorkItemNodeInstance workItemNodeInstance;
            if (nodeInstance instanceof WorkItemNodeInstance && workItemId == (workItemNodeInstance = (WorkItemNodeInstance)nodeInstance).getWorkItem().getId()) {
                return workItemNodeInstance;
            }
            if (!(nodeInstance instanceof NodeInstanceContainer) || (result = JenkinsJobWorkItemHandler.findWorkItemNodeInstance(workItemId, ((NodeInstanceContainer)nodeInstance).getNodeInstances())) == null) continue;
            return result;
        }
        return null;
    }

    public static class WorkItemCause
    extends Cause {
        public String getShortDescription() {
            return "Invoked by jBPM workflow plugin";
        }
    }
}

