/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jbpm;

import hudson.model.BuildListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JbpmPluginLogger {
    private static final Logger logger = LoggerFactory.getLogger(JbpmPluginLogger.class);
    private static BuildListener listener;

    public static synchronized void setListener(BuildListener listener) {
        JbpmPluginLogger.listener = listener;
    }

    private static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static synchronized void info(Throwable t) {
        JbpmPluginLogger.info(JbpmPluginLogger.getStackTrace(t));
    }

    public static synchronized void info(String message) {
        logger.info(message);
        listener.getLogger().println("INFO: " + message);
    }

    public static synchronized void debug(Throwable t) {
        JbpmPluginLogger.debug(JbpmPluginLogger.getStackTrace(t));
    }

    public static synchronized void debug(String message) {
        logger.debug(message);
        listener.getLogger().println("DEBUG: " + message);
    }

    public static synchronized void error(Throwable t) {
        JbpmPluginLogger.error(JbpmPluginLogger.getStackTrace(t));
    }

    public static synchronized void error(String message) {
        logger.error(message);
        listener.getLogger().println("ERROR: " + message);
    }

    public static synchronized void warn(Throwable t) {
        JbpmPluginLogger.warn(JbpmPluginLogger.getStackTrace(t));
    }

    public static synchronized void warn(String message) {
        logger.warn(message);
        listener.getLogger().println("WARN: " + message);
    }
}

