/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.htmlaudio.interfaces;

import hudson.Extension;
import hudson.model.RootAction;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import jenkins.plugins.htmlaudio.app.Configuration;
import jenkins.plugins.htmlaudio.app.NewNotificationsResult;
import jenkins.plugins.htmlaudio.app.NotificationService;
import jenkins.plugins.htmlaudio.domain.Notification;
import jenkins.plugins.htmlaudio.domain.NotificationId;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Flavor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public final class Controller
implements RootAction {
    private static final long LONG_POLLING_TIMEOUT = TimeUnit.SECONDS.toMillis(45L);
    private static final String CONTROLLER_URL = "/html-audio";
    private static final Logger logger = Logger.getLogger(Controller.class.getName());
    private Configuration configuration;
    private NotificationService notificationService;

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void doIsEnabledByDefault(StaplerRequest req, StaplerResponse resp) throws IOException {
        this.writeJsonResponse(resp, this.isEnabledByDefault());
    }

    private JSONObject isEnabledByDefault() {
        return new JSONObject().element("enabled", this.configuration.isEnabledByDefault());
    }

    private void writeJsonResponse(StaplerResponse response, JSONObject json) throws IOException {
        response.setContentType(Flavor.JSON.contentType);
        json.write((Writer)response.getWriter());
    }

    public void doNext(StaplerRequest req, StaplerResponse resp) throws IOException {
        this.writeJsonResponse(resp, this.findNext(req.getRemoteAddr(), req.getParameter("previous")));
    }

    private JSONObject findNext(String client, String previous) {
        boolean longPolling = this.configuration.isLongPollingEnabled();
        NewNotificationsResult next = this.notificationService.waitForNewNotifications(NotificationId.parseNotificationId(previous), longPolling ? LONG_POLLING_TIMEOUT : 0L);
        if (!next.getNotifications().isEmpty()) {
            logger.info("delivering " + next.getNotifications().size() + " event(s) to " + client + ", " + next.getNotifications());
        }
        return new JSONObject().element("currentNotification", this.createCurrentNotificationObject(next.getLastNotificationId())).element("notifications", (Collection)this.createNotificationsArray(next.getNotifications())).element("longPolling", longPolling);
    }

    private Object createCurrentNotificationObject(NotificationId lastNotificationId) {
        return lastNotificationId == null ? new JSONObject(true) : String.valueOf(lastNotificationId.getValue());
    }

    private JSONArray createNotificationsArray(Collection<Notification> notifications) {
        JSONArray result = new JSONArray();
        for (Notification n : notifications) {
            result.element(n.getSoundUrl());
        }
        return result;
    }

    public String getUrlName() {
        return CONTROLLER_URL;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }
}

