/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.htmlaudio.domain.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jenkins.plugins.htmlaudio.domain.Notification;
import jenkins.plugins.htmlaudio.domain.NotificationFactory;
import jenkins.plugins.htmlaudio.domain.NotificationId;
import jenkins.plugins.htmlaudio.domain.NotificationRepository;
import jenkins.plugins.htmlaudio.domain.impl.SimpleNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VolatileNotificationRepositoryAndFactory
implements NotificationRepository,
NotificationFactory {
    private final List<NotificationId> index = new ArrayList<NotificationId>();
    private final List<Notification> notifications = new ArrayList<Notification>();
    private long idSequence = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Notification createAndPersist(String soundUrl, String buildDetails) {
        if (soundUrl == null) {
            throw new IllegalArgumentException("soundUrl is required");
        }
        VolatileNotificationRepositoryAndFactory volatileNotificationRepositoryAndFactory = this;
        synchronized (volatileNotificationRepositoryAndFactory) {
            SimpleNotification n = new SimpleNotification(NotificationId.asNotificationId(this.idSequence++), soundUrl, buildDetails);
            this.index.add(n.getId());
            this.notifications.add(n);
            this.notifyAll();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotificationId getLastNotificationId() {
        VolatileNotificationRepositoryAndFactory volatileNotificationRepositoryAndFactory = this;
        synchronized (volatileNotificationRepositoryAndFactory) {
            return this.index.isEmpty() ? null : this.index.get(this.index.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Notification> findNewerThan(NotificationId id) {
        VolatileNotificationRepositoryAndFactory volatileNotificationRepositoryAndFactory = this;
        synchronized (volatileNotificationRepositoryAndFactory) {
            return VolatileNotificationRepositoryAndFactory.safeCopy(this.notifications.subList(this.from(id), this.to()));
        }
    }

    private static <E> List<E> safeCopy(List<E> source) {
        return new ArrayList<E>(source);
    }

    private int from(NotificationId id) {
        return id == null ? 0 : Math.abs(this.binarySearchIndex(id) + 1);
    }

    private int binarySearchIndex(NotificationId id) {
        return Collections.binarySearch(this.index, id);
    }

    private int to() {
        return this.index.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(NotificationRepository.NotificationRemover remover) {
        VolatileNotificationRepositoryAndFactory volatileNotificationRepositoryAndFactory = this;
        synchronized (volatileNotificationRepositoryAndFactory) {
            remover.remove(new RemovalIterator());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemovalIterator
    implements Iterator<Notification> {
        int pos = 0;
        Notification curr;

        private RemovalIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < VolatileNotificationRepositoryAndFactory.this.notifications.size();
        }

        @Override
        public Notification next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = (Notification)VolatileNotificationRepositoryAndFactory.this.notifications.get(this.pos++);
            return this.curr;
        }

        @Override
        public void remove() {
            if (this.curr == null) {
                throw new IllegalStateException();
            }
            --this.pos;
            VolatileNotificationRepositoryAndFactory.this.index.remove(this.pos);
            VolatileNotificationRepositoryAndFactory.this.notifications.remove(this.pos);
            this.curr = null;
        }
    }
}

