/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.htmlaudio.domain.impl;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import jenkins.plugins.htmlaudio.domain.Notification;
import jenkins.plugins.htmlaudio.domain.NotificationCleanupService;
import jenkins.plugins.htmlaudio.domain.NotificationRepository;

public class DefaultNotificationCleanupService
implements NotificationCleanupService {
    private static final long MAX_AGE_MS = TimeUnit.MINUTES.toMillis(1L);
    private NotificationRepository repo;

    public void setNotificationRepository(NotificationRepository repo) {
        this.repo = repo;
    }

    public void removeExpired() {
        this.repo.remove(new NotificationRepository.NotificationRemover(){

            @Override
            public void remove(Iterator<Notification> notifications) {
                while (notifications.hasNext() && DefaultNotificationCleanupService.this.tooOld(notifications.next())) {
                    notifications.remove();
                }
            }
        });
    }

    private boolean tooOld(Notification n) {
        return n.getAgeInMs() >= MAX_AGE_MS;
    }
}

