/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.htmlaudio.app.impl;

import hudson.Extension;
import jenkins.plugins.htmlaudio.app.Configuration;
import jenkins.plugins.htmlaudio.app.HtmlAudioNotifierPlugin;
import jenkins.plugins.htmlaudio.domain.BuildResult;
import jenkins.plugins.htmlaudio.util.StringUtils;

@Extension
public final class PluginConfiguration
implements Configuration {
    private HtmlAudioNotifierPlugin.PluginDescriptor descriptor;

    public void setPluginDescriptor(HtmlAudioNotifierPlugin.PluginDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public boolean isEnabledByDefault() {
        return this.descriptor.isEnabledByDefault();
    }

    public boolean isLongPollingEnabled() {
        return this.descriptor.isLongPollingEnabled();
    }

    public String getSoundUrl(BuildResult result) {
        return StringUtils.nullIfEmpty(this.findConfiguredSoundForResult(this.descriptor, result));
    }

    private String findConfiguredSoundForResult(HtmlAudioNotifierPlugin.PluginDescriptor descriptor, BuildResult result) {
        switch (result) {
            case SUCCESS: {
                return descriptor.getSuccessSoundUrl();
            }
            case SUCCESS_AFTER_FAILURE: {
                return descriptor.getSuccessAfterFailureSoundUrl();
            }
            case FAILURE: {
                return descriptor.getFailureSoundUrl();
            }
        }
        throw new IllegalArgumentException("unknown result-type " + (Object)((Object)result));
    }
}

