/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.htmlaudio.app.impl;

import hudson.Extension;
import hudson.model.Result;
import java.util.List;
import java.util.logging.Logger;
import jenkins.plugins.htmlaudio.app.Configuration;
import jenkins.plugins.htmlaudio.app.NewNotificationsResult;
import jenkins.plugins.htmlaudio.app.NotificationService;
import jenkins.plugins.htmlaudio.domain.BuildResult;
import jenkins.plugins.htmlaudio.domain.Notification;
import jenkins.plugins.htmlaudio.domain.NotificationCleanupService;
import jenkins.plugins.htmlaudio.domain.NotificationFactory;
import jenkins.plugins.htmlaudio.domain.NotificationId;
import jenkins.plugins.htmlaudio.domain.NotificationRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public final class DefaultNotificationService
implements NotificationService {
    private static final Logger logger = Logger.getLogger(NotificationService.class.getName());
    private NotificationRepository repo;
    private NotificationFactory factory;
    private Configuration configuration;
    private NotificationCleanupService cleanupService;

    public void setNotificationRepository(NotificationRepository repository) {
        this.repo = repository;
    }

    public void setNotificationFactory(NotificationFactory factory) {
        this.factory = factory;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setNotificationCleanupService(NotificationCleanupService cleanupService) {
        this.cleanupService = cleanupService;
    }

    @Override
    public NewNotificationsResult waitForNewNotifications(NotificationId previous, long timeoutMs) {
        this.cleanupService.removeExpired();
        NotificationId lastNotificationIdBeforeQuery = this.repo.getLastNotificationId();
        List<Notification> notifications = this.findNewerThanOrWait(previous, timeoutMs);
        return new NewNotificationsResult(this.findLastNotficationId(lastNotificationIdBeforeQuery, notifications), notifications);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Notification> findNewerThanOrWait(NotificationId previous, long timeoutMs) {
        NotificationRepository notificationRepository = this.repo;
        synchronized (notificationRepository) {
            List<Notification> result = this.repo.findNewerThan(previous);
            if (!result.isEmpty() || timeoutMs <= 0L) {
                return result;
            }
            try {
                this.repo.wait(timeoutMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return this.repo.findNewerThan(previous);
        }
    }

    private NotificationId findLastNotficationId(NotificationId lastNotificationIdBeforeQuery, List<Notification> notifications) {
        return notifications.isEmpty() ? lastNotificationIdBeforeQuery : notifications.get(notifications.size() - 1).getId();
    }

    @Override
    public void recordBuildCompletion(String buildDetails, Result result, Result previousResult) {
        this.cleanupService.removeExpired();
        String soundUrl = this.getSoundForResult(result, previousResult);
        if (soundUrl == null) {
            return;
        }
        Notification n = this.factory.createAndPersist(soundUrl, buildDetails);
        logger.info("created a new notification, " + n);
    }

    private String getSoundForResult(Result result, Result previousResult) {
        BuildResult br = BuildResult.toBuildResult(result, previousResult);
        return br == null ? null : this.configuration.getSoundUrl(br);
    }
}

