/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.htmlaudio.app;

import hudson.Extension;
import hudson.Plugin;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import jenkins.model.Jenkins;
import jenkins.plugins.htmlaudio.app.impl.DefaultNotificationService;
import jenkins.plugins.htmlaudio.app.impl.PluginConfiguration;
import jenkins.plugins.htmlaudio.domain.impl.DefaultNotificationCleanupService;
import jenkins.plugins.htmlaudio.domain.impl.VolatileNotificationRepositoryAndFactory;
import jenkins.plugins.htmlaudio.interfaces.Controller;
import jenkins.plugins.htmlaudio.interfaces.RunResultListener;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlAudioNotifierPlugin
extends Plugin
implements Describable<HtmlAudioNotifierPlugin> {
    @Initializer(after=InitMilestone.PLUGINS_PREPARED)
    public static void initializePlugin() {
        VolatileNotificationRepositoryAndFactory notificationRepoAndFactory = new VolatileNotificationRepositoryAndFactory();
        DefaultNotificationCleanupService notificationCleanupService = new DefaultNotificationCleanupService();
        notificationCleanupService.setNotificationRepository(notificationRepoAndFactory);
        HtmlAudioNotifierPlugin plugin = (HtmlAudioNotifierPlugin)Jenkins.getInstance().getPlugin(HtmlAudioNotifierPlugin.class);
        PluginConfiguration configuration = HtmlAudioNotifierPlugin.getComponent(PluginConfiguration.class);
        DefaultNotificationService notificationService = HtmlAudioNotifierPlugin.getComponent(DefaultNotificationService.class);
        Controller controller = HtmlAudioNotifierPlugin.getComponent(Controller.class);
        RunResultListener listener = HtmlAudioNotifierPlugin.getComponent(RunResultListener.class);
        configuration.setPluginDescriptor(plugin.getDescriptor());
        notificationService.setNotificationRepository(notificationRepoAndFactory);
        notificationService.setNotificationFactory(notificationRepoAndFactory);
        notificationService.setConfiguration(configuration);
        notificationService.setNotificationCleanupService(notificationCleanupService);
        controller.setConfiguration(configuration);
        controller.setNotificationService(notificationService);
        listener.setNotificationService(notificationService);
    }

    private static <T> T getComponent(Class<T> type) {
        return (T)Jenkins.getInstance().getExtensionList(type).get(0);
    }

    public PluginDescriptor getDescriptor() {
        return (PluginDescriptor)Jenkins.getInstance().getDescriptorByType(PluginDescriptor.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class PluginDescriptor
    extends Descriptor<HtmlAudioNotifierPlugin> {
        private volatile boolean enabledByDefault = false;
        private volatile boolean longPollingEnabled = false;
        private volatile String successSoundUrl = "";
        private volatile String successAfterFailureSoundUrl = "pop.wav";
        private volatile String failureSoundUrl = "horse.wav";

        public PluginDescriptor() {
            this.load();
        }

        public String getDisplayName() {
            return "HTML audio notifications";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.enabledByDefault = json.getBoolean("htmlAudioEnabledByDefault");
            this.longPollingEnabled = json.getBoolean("htmlAudioLongPollingEnabled");
            this.successSoundUrl = json.getString("htmlAudioSuccessSoundUrl");
            this.successAfterFailureSoundUrl = json.getString("htmlAudioSuccessAfterFailureSoundUrl");
            this.failureSoundUrl = json.getString("htmlAudioFailureSoundUrl");
            this.save();
            return super.configure(req, json);
        }

        public boolean isEnabledByDefault() {
            return this.enabledByDefault;
        }

        public void setEnabledByDefault(boolean enabledByDefault) {
            this.enabledByDefault = enabledByDefault;
        }

        public boolean isLongPollingEnabled() {
            return this.longPollingEnabled;
        }

        public void setLongPollingEnabled(boolean longPollingEnabled) {
            this.longPollingEnabled = longPollingEnabled;
        }

        public String getSuccessSoundUrl() {
            return this.successSoundUrl;
        }

        public void setSuccessSoundUrl(String successSoundUrl) {
            this.successSoundUrl = successSoundUrl;
        }

        public String getSuccessAfterFailureSoundUrl() {
            return this.successAfterFailureSoundUrl;
        }

        public void setSuccessAfterFailureSoundUrl(String successAfterFailureSoundUrl) {
            this.successAfterFailureSoundUrl = successAfterFailureSoundUrl;
        }

        public void setFailureSoundUrl(String failureSoundUrl) {
            this.failureSoundUrl = failureSoundUrl;
        }

        public String getFailureSoundUrl() {
            return this.failureSoundUrl;
        }
    }
}

