/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.htmlaudio.domain.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jenkins.plugins.htmlaudio.domain.Notification;
import jenkins.plugins.htmlaudio.domain.NotificationFactory;
import jenkins.plugins.htmlaudio.domain.NotificationId;
import jenkins.plugins.htmlaudio.domain.NotificationRepository;
import jenkins.plugins.htmlaudio.domain.impl.SimpleNotification;
import jenkins.plugins.htmlaudio.domain.impl.VolatileNotificationRepositoryAndFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class VolatileNotificationRepositoryAndFactory
implements NotificationRepository,
NotificationFactory {
    private final List<NotificationId> index = new ArrayList();
    private final List<Notification> notifications = new ArrayList();
    private long idSequence = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Notification createAndPersist(String soundUrl, String buildDetails) {
        if (soundUrl == null) {
            throw new IllegalArgumentException("soundUrl is required");
        }
        VolatileNotificationRepositoryAndFactory volatileNotificationRepositoryAndFactory = this;
        synchronized (volatileNotificationRepositoryAndFactory) {
            SimpleNotification n = new SimpleNotification(NotificationId.asNotificationId((long)this.idSequence++), soundUrl, buildDetails);
            this.index.add(n.getId());
            this.notifications.add(n);
            this.notifyAll();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationId getLastNotificationId() {
        VolatileNotificationRepositoryAndFactory volatileNotificationRepositoryAndFactory = this;
        synchronized (volatileNotificationRepositoryAndFactory) {
            return this.index.isEmpty() ? null : (NotificationId)this.index.get(this.index.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Notification> findNewerThan(NotificationId id) {
        VolatileNotificationRepositoryAndFactory volatileNotificationRepositoryAndFactory = this;
        synchronized (volatileNotificationRepositoryAndFactory) {
            return VolatileNotificationRepositoryAndFactory.safeCopy(this.notifications.subList(this.from(id), this.to()));
        }
    }

    private static <E> List<E> safeCopy(List<E> source) {
        return new ArrayList<E>(source);
    }

    private int from(NotificationId id) {
        return id == null ? 0 : Math.abs(this.binarySearchIndex(id) + 1);
    }

    private int binarySearchIndex(NotificationId id) {
        return Collections.binarySearch(this.index, id);
    }

    private int to() {
        return this.index.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(NotificationRepository.NotificationRemover remover) {
        VolatileNotificationRepositoryAndFactory volatileNotificationRepositoryAndFactory = this;
        synchronized (volatileNotificationRepositoryAndFactory) {
            remover.remove((Iterator)new RemovalIterator(this, null));
        }
    }

    static /* synthetic */ List access$100(VolatileNotificationRepositoryAndFactory x0) {
        return x0.notifications;
    }

    static /* synthetic */ List access$200(VolatileNotificationRepositoryAndFactory x0) {
        return x0.index;
    }
}

