/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.htmlaudio.domain.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.plugins.htmlaudio.domain.BuildEvent;
import jenkins.plugins.htmlaudio.domain.BuildEventRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VolatileBuildEventRepository
implements BuildEventRepository {
    private final Object mutex = new Object();
    private final List<Long> index = new ArrayList<Long>();
    private final List<BuildEvent> events = new ArrayList<BuildEvent>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(BuildEvent event) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.contains(event)) {
                throw new IllegalArgumentException(event + " already exists");
            }
            int position = this.insertToIndex(event.getId());
            this.events.add(position, event);
        }
    }

    private boolean contains(BuildEvent event) {
        return this.binarySearchIndex(event.getId()) >= 0;
    }

    private int binarySearchIndex(long id) {
        return Collections.binarySearch(this.index, id);
    }

    private int insertToIndex(long id) {
        this.index.add(id);
        Collections.sort(this.index);
        return this.binarySearchIndex(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(BuildEvent event) {
        Object object = this.mutex;
        synchronized (object) {
            int pos = this.binarySearchIndex(event.getId());
            if (pos < 0) {
                throw new IllegalArgumentException(event + " not found");
            }
            this.index.remove(pos);
            this.events.remove(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<BuildEvent> list() {
        Object object = this.mutex;
        synchronized (object) {
            return VolatileBuildEventRepository.safeCopy(this.events);
        }
    }

    private static <E> List<E> safeCopy(List<E> source) {
        return new ArrayList<E>(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<BuildEvent> findNewerThan(long buildEventId) {
        Object object = this.mutex;
        synchronized (object) {
            return VolatileBuildEventRepository.safeCopy(this.events.subList(this.from(buildEventId), this.to()));
        }
    }

    private int from(long id) {
        return Math.abs(this.binarySearchIndex(id) + 1);
    }

    private int to() {
        return this.index.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getLastEventId() {
        Object object = this.mutex;
        synchronized (object) {
            return this.index.isEmpty() ? null : this.index.get(this.index.size() - 1);
        }
    }
}

