/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.htmlaudio.app;

import hudson.Extension;
import hudson.Plugin;
import hudson.model.Describable;
import hudson.model.Descriptor;
import jenkins.model.Jenkins;
import jenkins.plugins.htmlaudio.app.Controller;
import jenkins.plugins.htmlaudio.app.RunResultListener;
import jenkins.plugins.htmlaudio.app.util.Configuration;
import jenkins.plugins.htmlaudio.app.util.ServerUrlResolver;
import jenkins.plugins.htmlaudio.domain.BuildEventCleanupService;
import jenkins.plugins.htmlaudio.domain.BuildEventRepository;
import jenkins.plugins.htmlaudio.domain.BuildResult;
import jenkins.plugins.htmlaudio.domain.impl.DefaultBuildEventCleanupService;
import jenkins.plugins.htmlaudio.domain.impl.VolatileBuildEventRepository;
import jenkins.plugins.htmlaudio.util.StringUtils;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlAudioNotifierPlugin
extends Plugin
implements Describable<HtmlAudioNotifierPlugin> {
    private final BuildEventRepository buildEventRepo = new VolatileBuildEventRepository();
    private final BuildEventCleanupService cleanupService = new DefaultBuildEventCleanupService();
    private final Configuration configuration = new PluginConfiguration();

    public void postInitialize() {
        this.initializeController();
        this.initializeRunResultListener();
    }

    private void initializeController() {
        Controller c = this.getComponent(Controller.class);
        c.setRepository(this.buildEventRepo);
        c.setCleanupService(this.cleanupService);
        c.setConfiguration(this.configuration);
        c.setServerUrlResolver(new ServerUrlResolver(){

            public String getRootUrl() {
                return Jenkins.getInstance().getRootUrl();
            }
        });
    }

    private <T> T getComponent(Class<T> type) {
        return (T)Jenkins.getInstance().getExtensionList(type).get(0);
    }

    private void initializeRunResultListener() {
        RunResultListener r = this.getComponent(RunResultListener.class);
        r.setRepository(this.buildEventRepo);
    }

    public PluginDescriptor getDescriptor() {
        return (PluginDescriptor)Jenkins.getInstance().getDescriptorByType(PluginDescriptor.class);
    }

    private class PluginConfiguration
    implements Configuration {
        private PluginConfiguration() {
        }

        public boolean isEnabledByDefault() {
            return HtmlAudioNotifierPlugin.this.getDescriptor().isEnabledByDefault();
        }

        public String getSoundUrl(BuildResult result) {
            return StringUtils.nullIfEmpty(this.findConfiguredSoundForResult(HtmlAudioNotifierPlugin.this.getDescriptor(), result));
        }

        private String findConfiguredSoundForResult(PluginDescriptor descriptor, BuildResult result) {
            switch (result) {
                case SUCCESS: {
                    return descriptor.getSuccessSoundUrl();
                }
                case FAILURE: {
                    return descriptor.getFailureSoundUrl();
                }
            }
            throw new IllegalArgumentException("unknown result-type " + (Object)((Object)result));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class PluginDescriptor
    extends Descriptor<HtmlAudioNotifierPlugin> {
        private volatile boolean enabledByDefault = false;
        private volatile String successSoundUrl = "pop.wav";
        private volatile String failureSoundUrl = "horse.wav";

        public PluginDescriptor() {
            this.load();
        }

        public String getDisplayName() {
            return "HTML audio notifications";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.enabledByDefault = json.getBoolean("htmlAudioEnabledByDefault");
            this.successSoundUrl = StringUtils.nullIfEmpty(json.getString("htmlAudioSuccessSoundUrl"));
            this.failureSoundUrl = StringUtils.nullIfEmpty(json.getString("htmlAudioFailureSoundUrl"));
            this.save();
            return super.configure(req, json);
        }

        public boolean isEnabledByDefault() {
            return this.enabledByDefault;
        }

        public void setEnabledByDefault(boolean enabledByDefault) {
            this.enabledByDefault = enabledByDefault;
        }

        public String getSuccessSoundUrl() {
            return this.successSoundUrl;
        }

        public void setSuccessSoundUrl(String successSoundUrl) {
            this.successSoundUrl = successSoundUrl;
        }

        public void setFailureSoundUrl(String failureSoundUrl) {
            this.failureSoundUrl = failureSoundUrl;
        }

        public String getFailureSoundUrl() {
            return this.failureSoundUrl;
        }
    }
}

