/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.htmlaudio.app;

import hudson.Extension;
import hudson.model.RootAction;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.logging.Logger;
import jenkins.plugins.htmlaudio.app.util.Configuration;
import jenkins.plugins.htmlaudio.app.util.ServerUrlResolver;
import jenkins.plugins.htmlaudio.domain.BuildEvent;
import jenkins.plugins.htmlaudio.domain.BuildEventCleanupService;
import jenkins.plugins.htmlaudio.domain.BuildEventRepository;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Flavor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public final class Controller
implements RootAction {
    private static final String PLUGIN_SOUNDS_URL = "plugin/html-audio-notifier/sounds/";
    private static final String CONTROLLER_URL = "/html-audio";
    private static final Logger logger = Logger.getLogger(Controller.class.getName());
    private ServerUrlResolver serverUrlResolver;
    private BuildEventRepository repository;
    private BuildEventCleanupService cleanupService;
    private Configuration configuration;

    public void setServerUrlResolver(ServerUrlResolver serverUrlResolver) {
        this.serverUrlResolver = serverUrlResolver;
    }

    public void setRepository(BuildEventRepository repository) {
        this.repository = repository;
    }

    public void setCleanupService(BuildEventCleanupService cleanupService) {
        this.cleanupService = cleanupService;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void doIsEnabledByDefault(StaplerRequest req, StaplerResponse resp) throws IOException {
        this.writeJsonResponse(resp, this.isEnabledByDefault());
    }

    JSONObject isEnabledByDefault() {
        return new JSONObject().element("enabled", this.configuration.isEnabledByDefault());
    }

    private void writeJsonResponse(StaplerResponse response, JSONObject json) throws IOException {
        response.setContentType(Flavor.JSON.contentType);
        json.write((Writer)response.getWriter());
    }

    public void doNext(StaplerRequest req, StaplerResponse resp) throws IOException {
        this.writeJsonResponse(resp, this.next(req.getRemoteAddr(), req.getParameter("previous")));
    }

    JSONObject next(String client, String previous) {
        this.removeExpiredEvents();
        Collection events = this.findEvents(previous);
        if (!events.isEmpty()) {
            logger.info("delivered " + events.size() + " event(s) to " + client + ", " + events);
        }
        return new JSONObject().element("currentNotification", this.getCurrentNotificationId()).element("notifications", (Collection)this.createNotificationsArray(events));
    }

    private void removeExpiredEvents() {
        this.cleanupService.removeExpiredEvents(this.repository);
    }

    private Collection<BuildEvent> findEvents(String previous) {
        Long previousEventId = this.parsePreviousEventId(previous);
        return previousEventId == null ? this.repository.list() : this.repository.findNewerThan(previousEventId.longValue());
    }

    private Object getCurrentNotificationId() {
        Long lastEventId = this.repository.getLastEventId();
        return lastEventId == null ? new JSONObject(true) : String.valueOf(lastEventId);
    }

    private Long parsePreviousEventId(String id) {
        if (id == null) {
            return null;
        }
        try {
            return Long.valueOf(id);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private JSONArray createNotificationsArray(Collection<BuildEvent> events) {
        JSONArray result = new JSONArray();
        for (BuildEvent e : events) {
            String url = this.configuration.getSoundUrl(e.getResult());
            if (url == null) continue;
            result.element(this.toAbsoluteUrl(url));
        }
        return result;
    }

    private String toAbsoluteUrl(String url) {
        return this.isAbsolute(url) ? url : this.convertToAbsoluteUrl(url);
    }

    private boolean isAbsolute(String url) {
        return url.contains("://");
    }

    private String convertToAbsoluteUrl(String relativeUrl) {
        return this.serverUrlResolver.getRootUrl() + PLUGIN_SOUNDS_URL + relativeUrl;
    }

    public void doToAbsoluteUrl(StaplerRequest req, StaplerResponse resp) throws IOException {
        resp.setContentType("text/plain");
        resp.getWriter().print(this.toAbsoluteUrl(req.getParameter("url")));
    }

    public String getUrlName() {
        return CONTROLLER_URL;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }
}

