/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.htmlaudio.domain;

import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import jenkins.plugins.htmlaudio.domain.BuildResult;

public final class BuildEvent {
    private static final AtomicLong idSequence = new AtomicLong();
    private final long id = idSequence.incrementAndGet();
    private final BuildResult result;
    private final long created;

    public BuildEvent(BuildResult result) {
        this(result, new Date());
    }

    public BuildEvent(BuildResult result, Date created) {
        this.result = result;
        this.created = created.getTime();
    }

    public long getId() {
        return this.id;
    }

    public BuildResult getResult() {
        return this.result;
    }

    public long getAgeInMs() {
        return System.currentTimeMillis() - this.created;
    }

    public String toString() {
        return "#" + this.id + "-" + (Object)((Object)this.result);
    }
}

