/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.htmlaudio.app;

import hudson.Extension;
import hudson.Plugin;
import hudson.model.Describable;
import hudson.model.Descriptor;
import jenkins.model.Jenkins;
import jenkins.plugins.htmlaudio.app.Controller;
import jenkins.plugins.htmlaudio.app.RunResultListener;
import jenkins.plugins.htmlaudio.app.util.Configuration;
import jenkins.plugins.htmlaudio.app.util.ServerUrlResolver;
import jenkins.plugins.htmlaudio.domain.BuildEventCleanupService;
import jenkins.plugins.htmlaudio.domain.BuildEventRepository;
import jenkins.plugins.htmlaudio.domain.impl.DefaultBuildEventCleanupService;
import jenkins.plugins.htmlaudio.domain.impl.VolatileBuildEventRepository;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlAudioNotifierPlugin
extends Plugin
implements Describable<HtmlAudioNotifierPlugin> {
    private final BuildEventRepository buildEventRepo = new VolatileBuildEventRepository();
    private final BuildEventCleanupService cleanupService = new DefaultBuildEventCleanupService();

    public void postInitialize() {
        this.initializeController();
        this.initializeRunResultListener();
    }

    private void initializeController() {
        Controller c = this.getComponent(Controller.class);
        c.setRepository(this.buildEventRepo);
        c.setCleanupService(this.cleanupService);
        c.setConfiguration(this.getDescriptor());
        c.setServerUrlResolver(new ServerUrlResolver(){

            public String getRootUrl() {
                return Jenkins.getInstance().getRootUrl();
            }
        });
    }

    private <T> T getComponent(Class<T> type) {
        return (T)Jenkins.getInstance().getExtensionList(type).get(0);
    }

    private void initializeRunResultListener() {
        RunResultListener r = this.getComponent(RunResultListener.class);
        r.setRepository(this.buildEventRepo);
    }

    public PluginDescriptor getDescriptor() {
        return (PluginDescriptor)Jenkins.getInstance().getDescriptorByType(PluginDescriptor.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class PluginDescriptor
    extends Descriptor<HtmlAudioNotifierPlugin>
    implements Configuration {
        private volatile boolean enabledByDefault = false;
        private volatile String failureSoundUrl = "horse.wav";

        public PluginDescriptor() {
            this.load();
        }

        public String getDisplayName() {
            return "HTML audio notifications";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.enabledByDefault = json.getBoolean("htmlAudioEnabledByDefault");
            this.failureSoundUrl = json.getString("htmlAudioFailureSoundUrl");
            if (StringUtils.isBlank((String)this.failureSoundUrl)) {
                this.failureSoundUrl = null;
            }
            this.save();
            return super.configure(req, json);
        }

        @Override
        public boolean isEnabledByDefault() {
            return this.enabledByDefault;
        }

        public void setEnabledByDefault(boolean enabledByDefault) {
            this.enabledByDefault = enabledByDefault;
        }

        @Override
        public String getFailureSoundUrl() {
            return this.failureSoundUrl;
        }

        public void setFailureSoundUrl(String failureSoundUrl) {
            this.failureSoundUrl = failureSoundUrl;
        }
    }
}

