/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.htmlaudio.app;

import hudson.Extension;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import jenkins.plugins.htmlaudio.domain.BuildEvent;
import jenkins.plugins.htmlaudio.domain.BuildEventRepository;
import jenkins.plugins.htmlaudio.domain.BuildResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public final class RunResultListener
extends RunListener<Run<?, ?>> {
    private static final Logger logger = Logger.getLogger(RunResultListener.class.getName());
    private BuildEventRepository repository;

    public void setRepository(BuildEventRepository repository) {
        this.repository = repository;
    }

    public void onCompleted(Run<?, ?> run, TaskListener listener) {
        Collection events = this.generateEvents(run.getResult());
        this.storeEvents(events);
        logger.fine("generated " + events.size() + " BuildEvent(s) based on " + run);
    }

    private Collection<BuildEvent> generateEvents(Result runResult) {
        ArrayList<BuildEvent> result = new ArrayList<BuildEvent>();
        for (BuildResult r : BuildResult.values()) {
            if (!r.correspondsTo(runResult)) continue;
            result.add(new BuildEvent(r));
        }
        return result;
    }

    private void storeEvents(Collection<BuildEvent> events) {
        for (BuildEvent e : events) {
            this.repository.add(e);
        }
    }
}

