/*
 * Decompiled with CFR 0.152.
 */
package com.nirima;

import com.nirima.AdaptivePluginProperty;
import com.nirima.AdaptivePluginRun;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class AdaptivePluginBuilder
extends Builder {
    private final String script;

    @DataBoundConstructor
    public AdaptivePluginBuilder(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        listener.getLogger().println("--- Run the script ---");
        AdaptivePluginProperty hbp = (AdaptivePluginProperty)build.getProject().getProperty(AdaptivePluginProperty.class);
        AdaptivePluginRun hr = hbp.getAdaptivePluginRun(build);
        return hr.runBuilder(build, launcher, listener);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private boolean useFrench;

        public FormValidation doCheckName(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a name");
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)"Isn't the name too short?");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Adaptive Plugin Configuration Script";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public boolean useFrench() {
            return this.useFrench;
        }
    }
}

