/*
 * Decompiled with CFR 0.152.
 */
package javolution.tools.colapi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class Colapi
extends AbstractMojo {
    private File directory;
    private String filter;
    private String encoding;
    private String keywordColor;
    private String commentColor;
    private String stringColor;
    private Pattern _pattern;
    private int _processed;
    private int _modified;
    private StringBuffer _doc = new StringBuffer(10000);
    private static final int DATA = 0;
    private static final int CODE = 1;
    private static final int IDENTIFIER = 2;
    private static final int COMMENT = 3;
    private static final int STRING_LITERAL = 4;
    private static final String[] KEYWORDS = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"};
    private static final HashSet IDENTIFIERS = new HashSet();

    public void execute() throws MojoExecutionException {
        if (!this.directory.exists()) {
            throw new MojoExecutionException("Directory: " + this.directory + " does not exist.");
        }
        this._pattern = Pattern.compile(this.filter);
        try {
            if (this.directory.isDirectory()) {
                this.processDirectory(this.directory);
            } else {
                this.processFile(this.directory);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not colorize", e);
        }
        finally {
            this.getLog().info((CharSequence)("Colapi processed " + this._processed + " files and modified " + this._modified + " in directory " + this.directory));
        }
    }

    private void processDirectory(File dir) throws Exception {
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (!pathname.isFile()) {
                    return false;
                }
                return Colapi.this._pattern.matcher(pathname.getPath()).matches();
            }
        });
        for (int i = 0; i < files.length; ++i) {
            this.processFile(files[i]);
        }
        File[] dirs = dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        for (int i = 0; i < dirs.length; ++i) {
            this.processDirectory(dirs[i]);
        }
    }

    private void processFile(File file) throws Exception {
        ++this._processed;
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.encoding));
        this._doc.setLength(0);
        int start = -1;
        int state = 0;
        boolean hasBeenModified = false;
        int read = in.read();
        while (read != -1) {
            if (state != 0) {
                if (read == 60) {
                    this._doc.append("&lt;");
                } else if (read == 62) {
                    this._doc.append("&gt;");
                } else if (read == 38) {
                    this._doc.append("&amp;");
                } else {
                    this._doc.append((char)read);
                }
            } else {
                this._doc.append((char)read);
            }
            switch (state) {
                case 0: {
                    if (read != 93 || !this.match("[code]")) break;
                    this._doc.setLength(this._doc.length() - 6);
                    this._doc.append("<code><pre>");
                    hasBeenModified = true;
                    state = 1;
                    break;
                }
                case 1: {
                    if (Character.isJavaIdentifierPart((char)read)) {
                        state = 2;
                        start = this._doc.length() - 1;
                        break;
                    }
                    if (read == 34) {
                        state = 4;
                        this._doc.insert(this._doc.length() - 1, "<font color=\"" + this.stringColor + "\">");
                        break;
                    }
                    if (read != 47 || this._doc.charAt(this._doc.length() - 2) != '/') break;
                    state = 3;
                    this._doc.insert(this._doc.length() - 2, "<font color=\"" + this.commentColor + "\">");
                    break;
                }
                case 4: {
                    if (read != 34 || this._doc.charAt(this._doc.length() - 2) == '\\') break;
                    this._doc.append("</font>");
                    state = 1;
                    break;
                }
                case 2: {
                    if (read == 93 && this.match("[/code]")) {
                        this._doc.setLength(this._doc.length() - 7);
                        this._doc.append("</pre></code>");
                        state = 0;
                        break;
                    }
                    if (read == 93 && this.match("[code]")) {
                        this.getLog().error((CharSequence)("Nested [code] tag found in file: " + file));
                        break;
                    }
                    if (Character.isJavaIdentifierPart((char)read)) break;
                    String name = this._doc.substring(start, this._doc.length() - 1);
                    if (IDENTIFIERS.contains(name)) {
                        this._doc.insert(start + name.length(), "</b></font>");
                        this._doc.insert(start, "<font color=\"" + this.keywordColor + "\"><b>");
                    }
                    state = 1;
                    break;
                }
                case 3: {
                    if (read != 10 && read != 13) break;
                    this._doc.insert(this._doc.length() - 1, "</font>");
                    state = 1;
                }
            }
            read = in.read();
        }
        in.close();
        if (hasBeenModified) {
            ++this._modified;
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.encoding);
            out.write(this._doc.toString());
            out.close();
            if (state != 0) {
                this.getLog().error((CharSequence)("Terminating [/code] tag not found in file: " + file));
            }
        }
    }

    private boolean match(String str) {
        int strLength;
        int docLength = this._doc.length();
        if (docLength < (strLength = str.length())) {
            return false;
        }
        int i = 0;
        int j = docLength - strLength;
        while (i < strLength) {
            if (this._doc.charAt(j++) == str.charAt(i++)) continue;
            return false;
        }
        return true;
    }

    static {
        for (int i = 0; i < KEYWORDS.length; ++i) {
            IDENTIFIERS.add(KEYWORDS[i]);
        }
    }
}

