/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.javabuilders.BuildException;

public class PropertyUtils {
    private static Map<String, Method> getters = new HashMap<String, Method>();
    private static Map<String, Method> setters = new HashMap<String, Method>();
    private static StringBuilder bld = new StringBuilder();

    public static boolean isValid(Object instance, String propertyName) {
        String name;
        boolean valid = false;
        if (instance != null && propertyName != null && propertyName.length() > 0 && PropertyUtils.getSetter(instance, name = PropertyUtils.getSetterName(propertyName)) != null) {
            valid = true;
        }
        return valid;
    }

    public static Class<?> getPropertyType(Object instance, String propertyName) {
        String name = PropertyUtils.getSetterName(propertyName);
        Method setter = PropertyUtils.getSetter(instance, name);
        return setter.getParameterTypes()[0];
    }

    public static Set<String> getPropertyNames(Class<?> clazz) {
        TreeSet<String> names = new TreeSet<String>();
        StringBuilder bld = new StringBuilder();
        if (clazz != null) {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1) continue;
                bld.setLength(0);
                bld.append(method.getName().substring(3, 4).toLowerCase());
                if (method.getName().length() > 4) {
                    bld.append(method.getName().substring(4));
                }
                names.add(bld.toString());
            }
        }
        return names;
    }

    public static Set<String> getPropertyNames(Object instance) {
        Set<String> names = new TreeSet<String>();
        if (instance != null) {
            names = PropertyUtils.getPropertyNames(instance.getClass());
        }
        return names;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setProperty(Object instance, String propertyName, Object value) {
        if (instance == null || propertyName == null) throw new BuildException("instance and propertyName cannot be null.", new Object[0]);
        String name = PropertyUtils.getSetterName(propertyName);
        Method setter = PropertyUtils.getSetter(instance, name);
        if (setter == null) throw new BuildException("Unable to find setter method: {0}.{1}", instance.getClass().getName(), name);
        try {
            setter.invoke(instance, value);
            return;
        }
        catch (Exception e) {
            throw new BuildException(e, "Failed to set {0}.{1} = {2}", instance.getClass().getName(), propertyName, value);
        }
    }

    public static Object getProperty(Object instance, String propertyName) {
        Object value = null;
        if (instance != null) {
            String name = PropertyUtils.getGetterName(propertyName);
            Method getter = PropertyUtils.getGetter(instance, name);
            if (getter != null) {
                try {
                    value = getter.invoke(instance, new Object[0]);
                }
                catch (Exception e) {
                    throw new BuildException(e, "Failed to get {0}.{1}", instance.getClass().getSimpleName(), propertyName);
                }
            } else {
                throw new BuildException("Unable to find getter method: {0}.{1}", instance.getClass().getName(), name);
            }
        }
        return value;
    }

    public static Object getNestedProperty(Object instance, String propertyExpression) {
        String part;
        String[] parts = propertyExpression.split("\\.");
        if (parts.length == 0) {
            parts = new String[]{propertyExpression};
        }
        Object value = null;
        for (int i = 0; i < parts.length && (value = PropertyUtils.getProperty(instance, part = parts[i])) != null && i != parts.length - 1; ++i) {
            instance = value;
        }
        return value;
    }

    private static Method getSetter(Object instance, String methodName) {
        bld.setLength(0);
        String key = bld.append(instance.getClass().getName()).append(".").append(methodName).toString();
        Method setter = setters.get(key);
        if (setter == null) {
            Method[] ms;
            for (Method m : ms = instance.getClass().getMethods()) {
                if (!m.getName().equals(methodName) || m.getParameterTypes().length != 1) continue;
                setter = m;
                setter.setAccessible(true);
                setters.put(key, setter);
                break;
            }
        }
        return setter;
    }

    private static Method getGetter(Object instance, String methodName) {
        bld.setLength(0);
        String key = bld.append(instance.getClass().getName()).append(".").append(methodName).toString();
        Method getter = getters.get(key);
        if (getter == null) {
            Method[] ms;
            for (Method m : ms = instance.getClass().getMethods()) {
                if (!m.getName().equals(methodName) || m.getParameterTypes().length != 0 || m.getReturnType() == null) continue;
                getter = m;
                getter.setAccessible(true);
                getters.put(key, getter);
                break;
            }
        }
        return getter;
    }

    public static String getSetterName(String propertyName) {
        StringBuilder bld = new StringBuilder(propertyName.length() + 3);
        bld.setLength(0);
        bld.append("set").append(propertyName.substring(0, 1).toUpperCase()).append(propertyName.substring(1));
        return bld.toString();
    }

    public static String getGetterName(String propertyName) {
        StringBuilder bld = new StringBuilder(propertyName.length() + 3);
        bld.setLength(0);
        bld.append("get").append(propertyName.substring(0, 1).toUpperCase()).append(propertyName.substring(1));
        return bld.toString();
    }

    public static Class<?> verifyGetter(Class<?> type, String getterName, Class<?> ... allowedReturnTypes) {
        try {
            Method m = type.getMethod(getterName, new Class[0]);
            Class<?> returnType = m.getReturnType();
            boolean validReturn = false;
            for (Class<?> allowed : allowedReturnTypes) {
                if (!allowed.isAssignableFrom(returnType)) continue;
                validReturn = true;
                break;
            }
            if (!validReturn) {
                StringBuilder bld = new StringBuilder();
                for (Class<?> allowed : allowedReturnTypes) {
                    if (bld.length() > 0) {
                        bld.append(", ");
                    }
                    bld.append(allowed.getName());
                }
                throw new BuildException("{0}.{1} return type is not in the list of allowed types:\n{2}", type.getName(), getterName, bld);
            }
            return returnType;
        }
        catch (Exception e) {
            throw new BuildException("Unable to find {0}.{1} getter. {2}", type.getName(), getterName, e.getMessage());
        }
    }
}

