/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.util;

import java.util.Map;
import java.util.Set;
import org.javabuilders.BuilderConfig;
import org.javabuilders.ChildrenCardinalityException;
import org.javabuilders.Node;
import org.javabuilders.TypeDefinition;

public class ChildrenCardinalityUtils {
    public static void checkChildrenCardinality(BuilderConfig config, Node current) {
        if (!current.getKey().equals("content")) {
            Object obj = current.getMainObject();
            Map<Class<?>, int[]> childrenCardinalities = TypeDefinition.getChildrenCardinality(config, obj.getClass());
            ChildrenCardinalityUtils.checkChildrenForUnexpectedTypes(current, current.getChildNodes(), childrenCardinalities.keySet());
            ChildrenCardinalityUtils.checkChildrenForUnexpectedTypes(current, current.getContentNodes(), childrenCardinalities.keySet());
            for (Class<?> type : childrenCardinalities.keySet()) {
                Set<Node> set;
                int[] limits = childrenCardinalities.get(type);
                if (childrenCardinalities.size() == 1 && limits[1] == 1) {
                    set = current.getChildNodes();
                    if (set.size() < limits[0]) {
                        throw new ChildrenCardinalityException("At least {0} child of type {1} is required: {2}", limits[0], type, current.getProperties());
                    }
                    if (set.size() > limits[1]) {
                        throw new ChildrenCardinalityException("No more than {0} child of type {1} is allowed: {2}", limits[1], type, current.getProperties());
                    }
                    set = current.getContentNodes(Object.class);
                    if (set.size() <= 0) continue;
                    throw new ChildrenCardinalityException("No child nodes are allowed: {0}", current.getProperties());
                }
                set = current.getChildNodes(type);
                if (set != null && set.size() > 0) {
                    for (Node node : set) {
                        if (node.getKey().equals("content")) continue;
                        throw new ChildrenCardinalityException("{0}: expected a list of type {1}, but found it as a child node instead.\n{1}", current.getMainObject().getClass().getSimpleName(), type, current.getProperties());
                    }
                }
                if ((set = current.getContentNodes(type)).size() < limits[0]) {
                    throw new ChildrenCardinalityException("At least {0} children of type {1} are required: {2}", limits[0], type, current.getProperties());
                }
                if (set.size() <= limits[1]) continue;
                if (limits[1] == 0 && Object.class.equals(type)) {
                    throw new ChildrenCardinalityException("No children are allowed under {0}: {1}", obj.getClass().getSimpleName(), current.getProperties());
                }
                throw new ChildrenCardinalityException("No more than {0} children of type {1} are allowed under {2}: {3}", limits[1], type, obj.getClass().getSimpleName(), current.getProperties());
            }
        }
    }

    private static void checkChildrenForUnexpectedTypes(Node current, Set<Node> nodes, Set<Class<?>> allowedTypes) {
        if (nodes != null) {
            for (Node node : nodes) {
                if (node.getKey().equals("content")) continue;
                boolean assignable = false;
                for (Class<?> type : allowedTypes) {
                    if (!type.isAssignableFrom(node.getMainObject().getClass())) continue;
                    assignable = true;
                    break;
                }
                if (assignable) continue;
                throw new ChildrenCardinalityException("{0}: Found unexpected type {1}.\nNot in list of allowed types {2}.\n{3}", current.getMainObject().getClass().getSimpleName(), node.getMainObject().getClass().getSimpleName(), allowedTypes, current.getProperties());
            }
        }
    }
}

