/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PropertyCombination {
    private List<String[]> combinations = new ArrayList<String[]>();

    public void add(String ... properties) {
        this.combinations.add(properties);
    }

    public boolean isValid(Collection<String> properties) {
        boolean isValid = false;
        for (String[] allowed : this.combinations) {
            boolean found = false;
            boolean notFound = false;
            for (String property : allowed) {
                if (properties.contains(property)) {
                    found = true;
                    continue;
                }
                notFound = true;
            }
            if (!found || notFound) continue;
            isValid = true;
            break;
        }
        return isValid;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.combinations.size() * 20);
        for (String[] properties : this.combinations) {
            if (builder.length() > 0) {
                builder.append(" | ");
            }
            for (String property : properties) {
                builder.append(property).append(" ");
            }
        }
        return builder.toString();
    }

    public int hashCode() {
        return this.combinations.hashCode();
    }
}

