/*
 * Decompiled with CFR 0.152.
 */
package jaxrs.examples.sse;

import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.sse.SseEventSource;

public final class SseClient {
    static final WebTarget TARGET = ClientBuilder.newClient().target("server-sent-events");

    private SseClient() {
    }

    public static void main(String[] args) {
        SseClient.consumeAllEvents();
    }

    private static void consumeAllEvents() {
        int counter;
        SseEventSource eventSource;
        try {
            eventSource = SseEventSource.target((WebTarget)TARGET).build();
            try {
                eventSource.register(System.out::println);
                eventSource.open();
                for (counter = 0; counter < 5; ++counter) {
                    TARGET.request().post(Entity.text((Object)("message " + counter)));
                }
                Thread.sleep(500L);
            }
            finally {
                if (eventSource != null) {
                    eventSource.close();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            eventSource = SseEventSource.target((WebTarget)TARGET).build();
            try {
                eventSource.register(System.out::println, Throwable::printStackTrace);
                eventSource.open();
                for (counter = 0; counter < 5; ++counter) {
                    TARGET.request().post(Entity.text((Object)("message " + counter)));
                }
                Thread.sleep(500L);
            }
            finally {
                if (eventSource != null) {
                    eventSource.close();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            eventSource = SseEventSource.target((WebTarget)TARGET).build();
            try {
                eventSource.register(System.out::println, Throwable::printStackTrace, () -> System.out.println("There will be no further events."));
                eventSource.open();
                for (counter = 0; counter < 5; ++counter) {
                    TARGET.request().post(Entity.text((Object)("message " + counter)));
                }
                Thread.sleep(500L);
            }
            finally {
                if (eventSource != null) {
                    eventSource.close();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

