/*
 * Decompiled with CFR 0.152.
 */
package jaxrs.examples.sse;

import jakarta.annotation.Resource;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseEventSink;
import java.io.IOException;

@Path(value="server-sent-events")
@Singleton
public class ServerSentEventsResource {
    private final Object outputLock = new Object();
    private final Sse sse;
    private volatile SseEventSink eventSink;
    @Resource
    private ManagedExecutorService executorService;

    @Inject
    public ServerSentEventsResource(Sse sse) {
        this.sse = sse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"text/event-stream"})
    public void getMessageQueue(@Context SseEventSink sseEventSink) {
        Object object = this.outputLock;
        synchronized (object) {
            if (this.eventSink != null) {
                throw new IllegalStateException("Server sink already served.");
            }
            this.eventSink = sseEventSink;
        }
    }

    @POST
    public void addMessage(String message) throws IOException {
        if (this.eventSink == null) {
            throw new IllegalStateException("No client connected.");
        }
        this.eventSink.send(this.sse.newEvent("custom-message"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    public void close() throws IOException {
        Object object = this.outputLock;
        synchronized (object) {
            if (this.eventSink != null) {
                this.eventSink.close();
                this.eventSink = null;
            }
        }
    }

    @POST
    @Path(value="domains/{id}")
    @Produces(value={"text/event-stream"})
    public void startDomain(@PathParam(value="id") String id, @Context SseEventSink sseEventSink) {
        this.executorService.submit(() -> {
            try {
                sseEventSink.send(this.sse.newEventBuilder().name("domain-progress").data(String.class, (Object)("starting domain " + id + " ...")).build());
                Thread.sleep(200L);
                sseEventSink.send(this.sse.newEvent("domain-progress", "50%"));
                Thread.sleep(200L);
                sseEventSink.send(this.sse.newEvent("domain-progress", "60%"));
                Thread.sleep(200L);
                sseEventSink.send(this.sse.newEvent("domain-progress", "70%"));
                Thread.sleep(200L);
                sseEventSink.send(this.sse.newEvent("domain-progress", "99%"));
                Thread.sleep(200L);
                sseEventSink.send(this.sse.newEvent("domain-progress", "Done."));
                sseEventSink.close();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
    }
}

