/*
 * Decompiled with CFR 0.152.
 */
package jaxrs.examples.sse;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.ServiceUnavailableException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.sse.OutboundSseEvent;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseBroadcaster;
import jakarta.ws.rs.sse.SseEventSink;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

@Path(value="items")
@Singleton
public class ItemStoreResource {
    private static final Logger LOGGER = Logger.getLogger(ItemStoreResource.class.getName());
    private final ReentrantReadWriteLock storeLock = new ReentrantReadWriteLock();
    private final LinkedList<String> itemStore = new LinkedList();
    private final Sse sse;
    private final SseBroadcaster broadcaster;
    private static volatile long reconnectDelay = 0L;

    @Inject
    public ItemStoreResource(Sse sse) {
        this.sse = sse;
        this.broadcaster = sse.newBroadcaster();
        this.broadcaster.onError((subscriber, e) -> LOGGER.log(Level.WARNING, "An exception has been thrown while broadcasting to an event output.", (Throwable)e));
        this.broadcaster.onClose(subscriber -> LOGGER.log(Level.INFO, "SSE event output has been closed."));
    }

    @GET
    @Produces(value={"text/plain"})
    public String listItems() {
        try {
            this.storeLock.readLock().lock();
            String string = this.itemStore.toString();
            return string;
        }
        finally {
            this.storeLock.readLock().unlock();
        }
    }

    @POST
    @Path(value="commands")
    public String processCommand(String command) {
        if (command == null || command.isEmpty()) {
            throw new BadRequestException("No command specified.");
        }
        if ("disconnect".equals(command)) {
            this.broadcaster.close();
            return "Disconnected.";
        }
        if (command.length() > "reconnect ".length() && command.startsWith("reconnect ")) {
            String when = command.substring("reconnect ".length());
            try {
                reconnectDelay = "now".equals(when) ? 0L : Long.parseLong(when);
                return "Reconnect strategy updated: " + when;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new BadRequestException("Command not recognized: '" + command + "'");
    }

    @GET
    @Path(value="events")
    @Produces(value={"text/event-stream"})
    public void itemEvents(@HeaderParam(value="Last-Event-ID") @DefaultValue(value="-1") int lastEventId, @Context SseEventSink serverSink) {
        if (lastEventId >= 0) {
            LOGGER.info("Received last event id :" + lastEventId);
            long delay = reconnectDelay;
            if (delay > 0L) {
                LOGGER.info("Non-zero reconnect delay [" + delay + "] - responding with HTTP 503.");
                throw new ServiceUnavailableException(Long.valueOf(delay));
            }
            LOGGER.info("Zero reconnect delay - reconnecting.");
            try {
                this.replayMissedEvents(lastEventId, serverSink);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.broadcaster.register(serverSink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replayMissedEvents(int lastEventId, SseEventSink eventOutput) throws IOException {
        try {
            this.storeLock.readLock().lock();
            int firstUnreceived = lastEventId + 1;
            int missingCount = this.itemStore.size() - firstUnreceived;
            if (missingCount > 0) {
                LOGGER.info("Replaying events - starting with id " + firstUnreceived);
                ListIterator it = this.itemStore.subList(firstUnreceived, this.itemStore.size()).listIterator();
                while (it.hasNext()) {
                    eventOutput.send(this.createItemEvent(it.nextIndex() + firstUnreceived, (String)it.next()));
                }
            } else {
                LOGGER.info("No events to replay.");
            }
        }
        finally {
            this.storeLock.readLock().unlock();
        }
    }

    @POST
    public void addItem(@FormParam(value="name") String name) {
        if (name == null) {
            return;
        }
        try {
            this.storeLock.writeLock().lock();
            int eventId = this.itemStore.size();
            this.itemStore.add(name);
            this.broadcaster.broadcast(this.createItemEvent(eventId, name));
            this.broadcaster.broadcast(this.sse.newEventBuilder().name("size").data(Integer.class, (Object)(eventId + 1)).build());
        }
        finally {
            this.storeLock.writeLock().unlock();
        }
    }

    private OutboundSseEvent createItemEvent(int eventId, String name) {
        Logger.getLogger(ItemStoreResource.class.getName()).info("Creating event id [" + eventId + "] name [" + name + "]");
        return this.sse.newEventBuilder().id("" + eventId).data(String.class, (Object)name).build();
    }
}

