/*
 * Decompiled with CFR 0.152.
 */
package jaxrs.examples.multipart;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;

@Path(value="/multipart")
public class MultipartResource {
    private static final String PDF_ROOT_DIR = System.getProperty("pdf.root.dir", "/myPDFs");

    @GET
    @Produces(value={"multipart/form-data"})
    public List<EntityPart> getAllPdfFilesInDirectory(@QueryParam(value="dirName") String dirName) throws IOException {
        File dir = this.getDirectoryIfExists(dirName);
        ArrayList<EntityPart> parts = new ArrayList<EntityPart>();
        for (File f : dir.listFiles()) {
            parts.add(EntityPart.withFileName((String)f.getName()).content((InputStream)new FileInputStream(f)).mediaType("application/pdf").build());
        }
        return parts;
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Response postNewPdfFiles(@QueryParam(value="dirName") String dirName, List<EntityPart> parts) throws IOException {
        File dir = this.getDirectoryIfExists(dirName);
        for (EntityPart p : parts) {
            File f = new File(dir, (String)p.getFileName().orElseThrow(BadRequestException::new));
            if (f.exists()) {
                throw new WebApplicationException(409);
            }
            InputStream content = p.getContent();
            try {
                Files.copy(content, f.toPath(), new CopyOption[0]);
            }
            finally {
                if (content == null) continue;
                content.close();
            }
        }
        return Response.ok().build();
    }

    @Path(value="/apply")
    @POST
    @Consumes(value={"multipart/form-data"})
    public Response applyForJob(@FormParam(value="name") String name, @FormParam(value="recentPhoto") InputStream photoStream, @FormParam(value="resume") EntityPart resume) {
        String resumeFileName = (String)resume.getFileName().orElseThrow(NotSupportedException::new);
        if (resumeFileName.toLowerCase().endsWith(".pdf")) {
            this.processPdfResume(resume.getContent());
        }
        return Response.ok((Object)"Application received").build();
    }

    private File getDirectoryIfExists(String dirName) {
        File dir = new File(PDF_ROOT_DIR, dirName);
        if (!dir.exists()) {
            throw new NotFoundException("dirName, " + dirName + ", does not exist");
        }
        return dir;
    }

    private void processPdfResume(InputStream is) {
    }
}

