/*
 * Decompiled with CFR 0.152.
 */
package jaxrs.examples.multipart;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class MultipartClient {
    private static final Logger LOG = Logger.getLogger(MultipartClient.class.getName());

    public boolean sendPdfs(Path dir) throws IOException {
        List parts = Files.list(dir).map(this::toPart).collect(Collectors.toList());
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target("http://localhost:9080/multipart?dirName=abc");
        Entity entity = Entity.entity(parts, (String)"multipart/form-data");
        Response response = target.request().post(entity);
        return response.getStatus() == 200;
    }

    private EntityPart toPart(Path file) {
        String filename = file.getFileName().toString();
        try {
            return EntityPart.withName((String)filename).content(filename, Files.newInputStream(file, new OpenOption[0])).mediaType("application/pdf").build();
        }
        catch (IOException ioex) {
            LOG.log(Level.WARNING, "Failed to process file {0}", file);
            return null;
        }
    }

    public List<Path> retrievePdfs(String remoteDirName) throws IOException {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target("http://localhost:9080/multipart").queryParam("dirName", new Object[]{remoteDirName});
        Response response = target.request(new String[]{"multipart/form-data"}).get();
        List parts = (List)response.readEntity((GenericType)new GenericType<List<EntityPart>>(){});
        return parts.stream().map(part -> {
            Path path;
            block8: {
                InputStream is = part.getContent();
                try {
                    Path file = Files.createFile(Paths.get((String)((Object)part.getFileName().orElse(part.getName() + ".pdf")), new String[0]), new FileAttribute[0]);
                    Files.copy(is, file, new CopyOption[0]);
                    path = file;
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioex) {
                        LOG.log(Level.WARNING, "Failed to process attachment part {0}", part);
                        return null;
                    }
                }
                is.close();
            }
            return path;
        }).collect(Collectors.toList());
    }
}

