/*
 * Decompiled with CFR 0.152.
 */
package jaxrs.examples.link.clusterservice;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import jaxrs.examples.link.clusterservice.Machine;
import jaxrs.examples.link.clusterservice.Model;

@Path(value="/cluster/machine/{name}")
public class MachineResource {
    @Context
    private UriInfo uriInfo;
    private Machine machine;

    @GET
    @Produces(value={"application/json"})
    public Response self(@PathParam(value="name") String name) {
        this.machine = this.getMachine(name);
        return Response.ok((Object)this.machine).links(this.getTransitionalLinks()).build();
    }

    @POST
    @Path(value="starter")
    @Produces(value={"application/json"})
    public Response starter(@PathParam(value="name") String name) {
        this.machine = this.getMachine(name);
        this.machine.setStatus(Machine.Status.STARTED);
        return Response.ok((Object)this.machine).links(this.getTransitionalLinks()).build();
    }

    @POST
    @Path(value="stopper")
    @Produces(value={"application/json"})
    public Response stopper(@PathParam(value="name") String name) {
        this.machine = this.getMachine(name);
        this.machine.setStatus(Machine.Status.STOPPED);
        return Response.ok((Object)this.machine).links(this.getTransitionalLinks()).build();
    }

    @POST
    @Path(value="suspender")
    @Produces(value={"application/json"})
    public Response suspender(@PathParam(value="name") String name) {
        this.machine = this.getMachine(name);
        this.machine.setStatus(Machine.Status.SUSPENDED);
        return Response.ok((Object)this.machine).links(this.getTransitionalLinks()).build();
    }

    private Machine getMachine(String name) {
        Machine m = Model.getMachine(name);
        if (m == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return m;
    }

    private Link[] getTransitionalLinks() {
        String name = this.machine.getName();
        URI uri = this.uriInfo.getRequestUri();
        URI baseUri = this.uriInfo.getBaseUri();
        Link self = Link.fromMethod(this.getClass(), (String)"self").baseUri(baseUri).rel("self").buildRelativized(uri, new Object[]{name});
        Link starter = Link.fromMethod(this.getClass(), (String)"starter").baseUri(baseUri).rel("starter").buildRelativized(uri, new Object[]{name});
        Link stopper = Link.fromMethod(this.getClass(), (String)"stopper").baseUri(baseUri).rel("stopper").buildRelativized(uri, new Object[]{name});
        Link suspender = Link.fromMethod(this.getClass(), (String)"suspender").baseUri(baseUri).rel("suspender").buildRelativized(uri, new Object[]{name});
        switch (this.machine.getStatus()) {
            case STOPPED: {
                return new Link[]{self, starter};
            }
            case STARTED: {
                return new Link[]{self, stopper, suspender};
            }
            case SUSPENDED: {
                return new Link[]{self, starter};
            }
        }
        throw new IllegalStateException();
    }
}

