/*
 * Decompiled with CFR 0.152.
 */
package jaxrs.examples.link.clusterservice;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import jaxrs.examples.link.clusterservice.Cluster;
import jaxrs.examples.link.clusterservice.MachineResource;
import jaxrs.examples.link.clusterservice.Model;

@Path(value="/cluster")
public class ClusterResource {
    @Context
    private UriInfo uriInfo;
    private Cluster cluster = Model.getCluster();

    @GET
    @Produces(value={"application/json"})
    public Response self() {
        return Response.ok((Object)this.cluster).links(this.getTransitionalLinks()).build();
    }

    @POST
    @Path(value="onliner")
    @Produces(value={"application/json"})
    public Response onliner() {
        this.cluster.setStatus(Cluster.Status.ONLINE);
        return Response.ok((Object)this.cluster).links(this.getTransitionalLinks()).build();
    }

    @POST
    @Path(value="offliner")
    @Produces(value={"application/json"})
    public Response offliner() {
        this.cluster.setStatus(Cluster.Status.OFFLINE);
        return Response.ok((Object)this.cluster).links(this.getTransitionalLinks()).build();
    }

    private Link[] getTransitionalLinks() {
        Link[] linkArray;
        URI uri = this.uriInfo.getRequestUri();
        URI baseUri = this.uriInfo.getBaseUri();
        Link self = Link.fromMethod(this.getClass(), (String)"self").baseUri(baseUri).rel("self").buildRelativized(uri, new Object[0]);
        Link item = Link.fromMethod(MachineResource.class, (String)"self").baseUri(baseUri).rel("item").buildRelativized(uri, new Object[0]);
        Link onliner = Link.fromMethod(this.getClass(), (String)"onliner").baseUri(baseUri).rel("onliner").buildRelativized(uri, new Object[0]);
        Link offliner = Link.fromMethod(this.getClass(), (String)"offliner").baseUri(baseUri).rel("offliner").buildRelativized(uri, new Object[0]);
        if (this.cluster.getStatus() == Cluster.Status.ONLINE) {
            Link[] linkArray2 = new Link[3];
            linkArray2[0] = self;
            linkArray2[1] = item;
            linkArray = linkArray2;
            linkArray2[2] = offliner;
        } else {
            Link[] linkArray3 = new Link[3];
            linkArray3[0] = self;
            linkArray3[1] = item;
            linkArray = linkArray3;
            linkArray3[2] = onliner;
        }
        return linkArray;
    }
}

