/*
 * Decompiled with CFR 0.152.
 */
package jaxrs.examples.filter.compression;

import jakarta.annotation.Priority;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jaxrs.examples.filter.compression.Gzipped;

@Provider
@Gzipped
@Priority(value=4000)
public class GzipEntityInterceptor
implements ReaderInterceptor,
WriterInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object aroundReadFrom(ReaderInterceptorContext ctx) throws IOException {
        if (!this.gzipEncoded(ctx)) {
            return ctx.proceed();
        }
        InputStream old = ctx.getInputStream();
        ctx.setInputStream((InputStream)new GZIPInputStream(old));
        try {
            Object object = ctx.proceed();
            return object;
        }
        finally {
            ctx.setInputStream(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aroundWriteTo(WriterInterceptorContext ctx) throws IOException {
        if (!this.acceptsGzip(ctx)) {
            ctx.proceed();
        } else {
            OutputStream old = ctx.getOutputStream();
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(old);
            ctx.setOutputStream((OutputStream)gzipOutputStream);
            try {
                ctx.proceed();
            }
            finally {
                gzipOutputStream.finish();
                ctx.setOutputStream(old);
            }
        }
    }

    private boolean acceptsGzip(WriterInterceptorContext ctx) {
        return true;
    }

    private boolean gzipEncoded(ReaderInterceptorContext ctx) {
        return true;
    }
}

