/*
 * Decompiled with CFR 0.152.
 */
package jaxrs.examples.client.spec;

import jakarta.ws.rs.client.AsyncInvoker;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.concurrent.Future;
import jaxrs.examples.client.custom.ThrottledClient;

public class SpecExamples {
    public void clientBootstrapping() {
        Client defaultClient = ClientBuilder.newClient();
        defaultClient.property("CUSTOM_PROPERTY", (Object)"CUSTOM_VALUE");
        assert (defaultClient != null);
        Client defaultConfiguredClient = ClientBuilder.newClient((Configuration)defaultClient.getConfiguration());
        assert (defaultConfiguredClient != null);
        ThrottledClient myClient = new ThrottledClient();
        assert (myClient != null);
        ThrottledClient myConfiguredClient = new ThrottledClient(10);
        assert (myConfiguredClient != null);
    }

    public void fluentMethodChaining() {
        Client client = ClientBuilder.newClient();
        Response res = client.target("http://example.org/hello").request(new String[]{"text/plain"}).get();
        Response res2 = client.target("http://example.org/hello").queryParam("MyParam", new Object[]{"..."}).request(new String[]{"text/plain"}).header("MyHeader", (Object)"...").get();
    }

    public void typeRelationships() {
        Invocation.Builder builder;
        Client client = ClientBuilder.newClient();
        WebTarget uri = client.target("");
        Invocation.Builder syncInvoker = builder = uri.request(new String[]{"text/plain"});
        AsyncInvoker asyncInvoker = builder.async();
        Invocation inv = builder.buildGet();
        Response r1 = builder.get();
        Response r2 = syncInvoker.get();
        Response r3 = inv.invoke();
        Future fr1 = asyncInvoker.get();
        Future fr2 = inv.submit();
    }

    public void benefitsOfResourceUri() {
        Client client = ClientBuilder.newClient();
        WebTarget base = client.target("http://example.org/");
        WebTarget hello = base.path("hello").path("{whom}");
        WebTarget whomToGreet = hello.resolveTemplate("whom", (Object)"world");
        Response res = whomToGreet.request().get();
    }

    public void gettingAndPostingCustomers() {
        Client client = ClientBuilder.newClient();
        Customer c = (Customer)client.target("http://examples.org/customers/123").request(new String[]{"application/xml"}).get(Customer.class);
        Response res = client.target("http://examples.org/premium-customers/").request().post(Entity.entity((Object)c, (String)"application/xml"));
    }

    public void asyncSamples() throws Exception {
        Client client = ClientBuilder.newClient();
        Future fc = client.target("http://examples.org/customers/123").request(new String[]{"application/xml"}).async().get(Customer.class);
        Customer c = (Customer)fc.get();
    }

    @XmlRootElement
    public static class Customer {
        private final String name;

        public Customer(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

