/*
 * Decompiled with CFR 0.152.
 */
package jaxrs.examples.client.cache;

import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import jaxrs.examples.client.cache.CacheEntry;

public class CacheResponseFilter
implements ClientResponseFilter {
    private Map<String, CacheEntry> cacheStore;

    public CacheResponseFilter(Map<String, CacheEntry> store) {
        this.cacheStore = store;
    }

    public void filter(ClientRequestContext request, ClientResponseContext response) throws IOException {
        this.store(request, response);
    }

    private void store(ClientRequestContext request, ClientResponseContext response) {
        if (request.getMethod().equalsIgnoreCase("GET")) {
            byte[] body = CacheResponseFilter.readFromStream(1024, response.getEntityStream());
            CacheEntry cacheEntry = new CacheEntry(response.getStatus(), (MultivaluedMap<String, String>)new MultivaluedHashMap(response.getHeaders()), body);
            this.cacheStore.put(request.getUri().toString(), cacheEntry);
            response.setEntityStream((InputStream)new ByteArrayInputStream(cacheEntry.getBody()));
        }
    }

    private static byte[] readFromStream(int bufferSize, InputStream entityStream) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[bufferSize];
        int wasRead = 0;
        do {
            try {
                wasRead = entityStream.read(buffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (wasRead <= 0) continue;
            baos.write(buffer, 0, wasRead);
        } while (wasRead > -1);
        return baos.toByteArray();
    }
}

