/*
 * Decompiled with CFR 0.152.
 */
package jaxrs.examples.client.cache;

import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import jaxrs.examples.client.cache.CacheEntry;

public class CacheEntryLocator
implements ClientRequestFilter {
    private Map<String, CacheEntry> cache;

    public CacheEntryLocator(Map<String, CacheEntry> cache) {
        this.cache = cache;
    }

    public void filter(ClientRequestContext request) throws IOException {
        this.load(request);
    }

    private void load(ClientRequestContext request) {
        CacheEntry cacheEntry;
        if (request.getMethod().equalsIgnoreCase("GET") && (cacheEntry = this.cache.get(request.getUri().toString())) != null) {
            Response.ResponseBuilder responseBuilder = Response.status((int)cacheEntry.getStatus()).entity((Object)new ByteArrayInputStream(cacheEntry.getBody()));
            for (Map.Entry mapEntry : cacheEntry.getHeaders().entrySet()) {
                for (String value : (List)mapEntry.getValue()) {
                    responseBuilder.header((String)mapEntry.getKey(), (Object)value);
                }
            }
            request.abortWith(responseBuilder.build());
        }
    }
}

