/*
 * Decompiled with CFR 0.152.
 */
package jaxrs.examples.client;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.InvocationCallback;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.SSLContext;
import jaxrs.examples.client.custom.ThrottledClient;

public class BasicExamples {
    public void clientBootstrapping() {
        Client defaultClient = ClientBuilder.newClient();
        assert (defaultClient != null);
        defaultClient.property("CUSTOM_PROPERTY", (Object)"CUSTOM_VALUE");
        Client defaultConfiguredClient = ClientBuilder.newClient((Configuration)defaultClient.getConfiguration());
        assert (defaultConfiguredClient != null);
        ThrottledClient myClient = new ThrottledClient();
        ThrottledClient myConfiguredClient = new ThrottledClient(10);
    }

    public void creatingResourceAndSubResourceUris() {
        WebTarget customersUri = ClientBuilder.newClient().target("http://jaxrs.examples.org/jaxrsApplication/customers");
        WebTarget anyCustomerUri = customersUri.path("{id}");
        WebTarget customer123 = anyCustomerUri.resolveTemplate("id", (Object)123);
        assert (customer123 != null);
    }

    public void creatingClientRequestsAndInvocations() {
        Client client = ClientBuilder.newClient();
        Response response = client.target("http://jaxrs.examples.org/jaxrsApplication/customers").request(new String[]{"application/xml"}).header("Foo", (Object)"Bar").get();
        assert (response.getStatus() == 200);
    }

    public void autoCloseableResponse() {
        Client client = ClientBuilder.newClient();
        try (Response response = client.target("http://jaxrs.examples.org/jaxrsApplication/customers").request(new String[]{"application/xml"}).header("Foo", (Object)"Bar").get();){
            assert (response.getStatus() == 200);
        }
    }

    public void creatingClientInstanceUsingClientBuilder() {
        SSLContext sslContext = null;
        Client client = ClientBuilder.newBuilder().sslContext(sslContext).build();
        assert (client != null);
    }

    public void creatingResourceUriRequestsAndInvocations() {
        Client client = ClientBuilder.newClient();
        WebTarget customersUri = client.target("http://jaxrs.examples.org/jaxrsApplication/customers");
        Response response = customersUri.request(new String[]{"application/xml"}).header("Foo", (Object)"Bar").get();
        assert (response.getStatus() == 200);
    }

    public void defaultResponse() {
        WebTarget customersUri = ClientBuilder.newClient().target("http://jaxrs.examples.org/jaxrsApplication/customers");
        Response response = customersUri.path("{id}").resolveTemplate("id", (Object)123).request().get();
        Customer customer = (Customer)response.readEntity(Customer.class);
        assert (customer != null);
        response = customersUri.request().post(Entity.xml((Object)new Customer("Marek")));
        assert (response.getStatus() == 201);
    }

    public void typedResponse() {
        Customer customer = (Customer)ClientBuilder.newClient().target("http://jaxrs.examples.org/jaxrsApplication/customers/{id}").resolveTemplate("id", (Object)123).request().get(Customer.class);
        assert (customer != null);
    }

    public void typedGenericResponse() {
        List customers = (List)ClientBuilder.newClient().target("http://jaxrs.examples.org/jaxrsApplication/customers").request().get((GenericType)new GenericType<List<Customer>>(){});
        assert (customers != null);
    }

    public void responseUsingSubResourceClient() {
        WebTarget customersUri = ClientBuilder.newClient().target("http://jaxrs.examples.org/jaxrsApplication/customers");
        WebTarget customer = customersUri.path("{id}");
        Response response = customersUri.request().post(Entity.xml((Object)new Customer("Bill")));
        assert (response.getStatus() == 201);
        Customer favorite = (Customer)customer.resolveTemplate("id", (Object)123).request().get(Customer.class);
        assert (favorite != null);
        favorite = (Customer)customer.resolveTemplate("id", (Object)123).request().get(Customer.class);
        assert (favorite != null);
    }

    public void asyncResponse() throws Exception {
        Future future = ClientBuilder.newClient().target("http://jaxrs.examples.org/jaxrsApplication/customers/{id}").resolveTemplate("id", (Object)123).request().async().get();
        Response response = (Response)future.get();
        Customer customer = (Customer)response.readEntity(Customer.class);
        assert (customer != null);
    }

    public void typedAsyncResponse() throws Exception {
        Future customer = ClientBuilder.newClient().target("http://jaxrs.examples.org/jaxrsApplication/customers/{id}").resolveTemplate("id", (Object)123).request().async().get(Customer.class);
        assert (customer.get() != null);
    }

    public void asyncCallback() {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target("http://jaxrs.examples.org/jaxrsApplication/customers/{id}");
        target.resolveTemplate("id", (Object)123).request().async().get((InvocationCallback)new InvocationCallback<Customer>(){

            public void completed(Customer customer) {
            }

            public void failed(Throwable error) {
            }
        });
        Future handle = target.resolveTemplate("id", (Object)456).request().async().get((InvocationCallback)new InvocationCallback<Response>(){

            public void completed(Response response) {
            }

            public void failed(Throwable error) {
            }
        });
        handle.cancel(true);
    }

    public void asyncCallbackUsingSubResourceClient() throws Exception {
        Client client = ClientBuilder.newClient();
        WebTarget anyCustomerUri = client.target("http://jaxrs.examples.org/jaxrsApplication/customers/{id}");
        Future handle = anyCustomerUri.resolveTemplate("id", (Object)123).request().async().get((InvocationCallback)new InvocationCallback<Customer>(){

            public void completed(Customer customer) {
            }

            public void failed(Throwable throwable) {
            }
        });
        handle.cancel(true);
        anyCustomerUri.resolveTemplate("id", (Object)456).request().async().get((InvocationCallback)new InvocationCallback<Response>(){

            public void completed(Response customer) {
            }

            public void failed(Throwable throwable) {
            }
        });
        Future response = anyCustomerUri.resolveTemplate("id", (Object)789).request().cookie(new Cookie("fooName", "XYZ")).async().get();
        assert (response.get() != null);
    }

    public void commonFluentUseCases() {
        Client client = ClientBuilder.newClient();
        client.target("http://examples.jaxrs.com/");
        client.target("http://examples.jaxrs.com/").request(new String[]{"text/plain"}).get();
        client.target("http://examples.jaxrs.com/").request(new String[]{"text/plain"}).async().get();
        client.target("http://examples.jaxrs.com/").request().buildPut(Entity.text((Object)"Hi")).invoke();
        client.target("http://examples.jaxrs.com/").request(new String[]{"text/plain"}).buildGet().submit();
        client.target("http://examples.jaxrs.com/").path("123").request(new String[]{"text/plain"}).get();
        client.target("http://examples.jaxrs.com/").path("123").request(new String[]{"text/plain"}).async().get();
        client.target("http://examples.jaxrs.com/").path("123").request(new String[]{"text/plain"}).buildGet().invoke();
        client.target("http://examples.jaxrs.com/").path("123").request(new String[]{"text/plain"}).buildGet().submit();
        client.target("http://examples.jaxrs.com/").path("123").request(new String[]{"text/plain"}).get();
        client.target("http://examples.jaxrs.com/").path("123").request(new String[]{"text/plain"}).async().get();
        client.target("http://examples.jaxrs.com/").path("123").request(new String[]{"text/plain"}).buildGet().invoke();
        client.target("http://examples.jaxrs.com/").path("123").request(new String[]{"text/plain"}).buildGet().submit();
        client.target("http://examples.jaxrs.com/").path("123").request(new String[]{"text/plain"}).header("custom-name", (Object)"custom_value").get();
        client.target("http://examples.jaxrs.com/").path("123").request(new String[]{"text/plain"}).header("custom-name", (Object)"custom_value").async().get();
        client.target("http://examples.jaxrs.com/").path("123").request(new String[]{"text/plain"}).header("custom-name", (Object)"custom_value").buildGet().invoke();
        client.target("http://examples.jaxrs.com/").path("123").request(new String[]{"text/plain"}).header("custom-name", (Object)"custom_value").buildGet().submit();
        client.target("http://examples.jaxrs.com/").path("123").request(new String[]{"application/json"}).post(Entity.form((Form)new Form("param1", "a").param("param2", "b")));
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)"param1", (Object)"a");
        formData.add((Object)"param2", (Object)"b");
        client.target("http://examples.jaxrs.com/").path("123").request(new String[]{"application/json"}).post(Entity.form((MultivaluedMap)formData));
        TestFeature testFeature = new TestFeature();
        client.register((Object)testFeature);
        client.target("http://examples.jaxrs.com/").register((Object)testFeature);
        client.target("http://examples.jaxrs.com/").request(new String[]{"text/plain"}).property("foo", (Object)"bar");
        client.target("http://examples.jaxrs.com/").request(new String[]{"text/plain"}).buildGet().property("foo", (Object)"bar");
    }

    public void invocationFlexibility() {
        Invocation i = ClientBuilder.newClient().target("http://examples.jaxrs.com/greeting").request(new String[]{"text/plain"}).header("custom-name", (Object)"custom_value").buildPut(Entity.text((Object)"Hi"));
        i.invoke();
    }

    public void customContractRegistration() {
        Client configurable = ClientBuilder.newClient();
        configurable.register(MyProvider.class, new Class[]{ContainerRequestContext.class});
        configurable.register(MyProvider.class, new Class[]{ContainerRequestContext.class, ReaderInterceptor.class});
        configurable.register((Object)new MyProvider(), new Class[]{WriterInterceptor.class});
        configurable.register((Object)new MyProvider(), new Class[]{WriterInterceptor.class, ReaderInterceptor.class});
    }

    public void customExecutor() {
        ExecutorService executorService = Executors.newCachedThreadPool();
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(256);
        Client client = ClientBuilder.newBuilder().executorService(executorService).scheduledExecutorService(scheduledExecutorService).build();
    }

    public void responseStatus20() {
        Client client = ClientBuilder.newClient();
        Response response = client.target("https://github.com/jax-rs/").request().get();
        switch (response.getStatus()) {
            case 200: {
                return;
            }
            case 201: {
                return;
            }
            case 404: {
                return;
            }
            case 500: {
                return;
            }
        }
    }

    public void responseStatus21() {
        Client client = ClientBuilder.newClient();
        Response response = client.target("https://github.com/jax-rs/").request().get();
        switch (response.getStatusInfo().toEnum()) {
            case OK: {
                return;
            }
            case CREATED: {
                return;
            }
            case NOT_FOUND: {
                return;
            }
            case INTERNAL_SERVER_ERROR: {
                return;
            }
        }
    }

    public static class MyProvider
    implements ReaderInterceptor,
    WriterInterceptor,
    ContainerRequestFilter {
        public void filter(ContainerRequestContext requestContext) throws IOException {
        }

        public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
            return null;
        }

        public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        }
    }

    public static class TestFeature
    implements Feature {
        public boolean configure(FeatureContext context) {
            return true;
        }
    }

    @XmlRootElement
    public static class Customer {
        private final String name;

        public Customer(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

