/*
 * Decompiled with CFR 0.152.
 */
package jaxrs.examples.bootstrap;

import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.core.Application;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import jaxrs.examples.bootstrap.HelloWorld;

public final class TlsJavaSeBootstrapExample {
    private TlsJavaSeBootstrapExample() {
    }

    public static void main(String[] args) throws GeneralSecurityException, IOException, InterruptedException {
        HelloWorld application = new HelloWorld();
        Path keyStorePath = Paths.get(args[0], new String[0]);
        char[] passphrase = args[1].toCharArray();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(Files.newInputStream(keyStorePath, new OpenOption[0]), passphrase);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, passphrase);
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(keyManagerFactory.getKeyManagers(), null, null);
        SeBootstrap.Configuration requestedConfiguration = SeBootstrap.Configuration.builder().protocol("HTTPS").sslContext(sslContext).build();
        SeBootstrap.start((Application)application, (SeBootstrap.Configuration)requestedConfiguration).thenAccept(instance -> {
            instance.stopOnShutdown(stopResult -> System.out.printf("Stop result: %s [Native stop result: %s].%n", stopResult, stopResult.unwrap(Object.class)));
            URI uri = instance.configuration().baseUri();
            System.out.printf("Instance %s running at %s [Native handle: %s].%n", instance, uri, instance.unwrap(Object.class));
            System.out.println("Send SIGKILL to shutdown.");
        });
        Thread.currentThread().join();
    }
}

