/*
 * Decompiled with CFR 0.152.
 */
package jaxrs.examples.async;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

@Path(value="/async/nextMessage")
@Produces(value={"text/plain"})
@Consumes(value={"text/plain"})
public class SimpleAsyncEventResource {
    private static final BlockingQueue<AsyncResponse> SUSPENDED = new ArrayBlockingQueue<AsyncResponse>(5);

    @GET
    public void readMessage(@Suspended AsyncResponse ar) throws InterruptedException {
        SUSPENDED.put(ar);
    }

    @POST
    public String postMessage(String message) throws InterruptedException {
        SUSPENDED.take().resume((Object)message);
        return "Message sent";
    }
}

