/*
 * Decompiled with CFR 0.152.
 */
package jaxrs.examples.async;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@Path(value="/async/longRunning")
@Produces(value={"text/plain"})
public class LongRunningAsyncOperationResource {
    @GET
    @Path(value="sync")
    public String basicSyncExample() {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(LongRunningAsyncOperationResource.class.getName()).log(Level.SEVERE, "Response processing interrupted", ex);
        }
        return "Hello async world!";
    }

    @GET
    @Path(value="async")
    public void asyncExample(@Suspended AsyncResponse ar) {
        ar.setTimeout(15L, TimeUnit.SECONDS);
        Executors.newSingleThreadExecutor().submit(() -> {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(LongRunningAsyncOperationResource.class.getName()).log(Level.SEVERE, "Response processing interrupted", ex);
            }
            ar.resume((Object)"Hello async world!");
        });
    }

    @GET
    @Path(value="asyncSelective")
    public void selectiveSuspend(@QueryParam(value="query") String query, @Suspended AsyncResponse ar) {
        if (!this.isComplex(query)) {
            ar.resume((Object)("Simple result for " + query));
        } else {
            Executors.newSingleThreadExecutor().submit(() -> {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(LongRunningAsyncOperationResource.class.getName()).log(Level.SEVERE, "Response processing interrupted", ex);
                }
                ar.resume((Object)("Complex result for " + query));
            });
        }
    }

    private boolean isComplex(String query) {
        return new Random(query.hashCode()).nextBoolean();
    }

    @GET
    @Path(value="asyncTimeoutOverride")
    public void overriddenTimeoutAsync(@QueryParam(value="timeOut") Long timeOut, @QueryParam(value="timeUnit") TimeUnit timeUnit, @Suspended AsyncResponse ar) {
        if (timeOut != null && timeUnit != null) {
            ar.setTimeout(timeOut.longValue(), timeUnit);
        } else {
            ar.setTimeout(15L, TimeUnit.SECONDS);
        }
        Executors.newSingleThreadExecutor().submit(() -> {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(LongRunningAsyncOperationResource.class.getName()).log(Level.SEVERE, "Response processing interrupted", ex);
            }
            ar.resume((Object)"Hello async world!");
        });
    }

    @GET
    @Path(value="asyncHandleUsage")
    public void suspendHandleUsageExample(@Suspended AsyncResponse ar) {
        ar.setTimeout(15L, TimeUnit.SECONDS);
        Executors.newSingleThreadExecutor().submit(() -> {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(LongRunningAsyncOperationResource.class.getName()).log(Level.SEVERE, "Response processing interrupted", ex);
            }
            ar.resume((Object)"Hello async world!");
        });
        ar.setTimeoutHandler(r -> Logger.getLogger(LongRunningAsyncOperationResource.class.getName()).log(Level.INFO, "Context resumed with a response!"));
    }
}

