/*
 * Decompiled with CFR 0.152.
 */
package jaxrs.examples.async;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.CompletionCallback;
import jakarta.ws.rs.container.Suspended;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

@Path(value="/async/nextMessage")
@Produces(value={"text/plain"})
@Consumes(value={"text/plain"})
public class AsyncEventResource
implements CompletionCallback {
    private static final BlockingQueue<String> MESSAGES = new ArrayBlockingQueue<String>(5);

    @GET
    public void readMessage(@Suspended AsyncResponse ar) {
        ar.register(AsyncEventResource.class);
        Executors.newSingleThreadExecutor().submit(() -> {
            try {
                ar.resume((Object)MESSAGES.take());
            }
            catch (InterruptedException ex) {
                Logger.getLogger(AsyncEventResource.class.getName()).log(Level.SEVERE, null, ex);
                ar.cancel();
            }
        });
    }

    @POST
    public void postMessage(String message, @Suspended AsyncResponse asyncResponse) {
        Executors.newSingleThreadExecutor().submit(() -> {
            try {
                MESSAGES.put(message);
                asyncResponse.resume((Object)"Message stored.");
            }
            catch (InterruptedException ex) {
                Logger.getLogger(AsyncEventResource.class.getName()).log(Level.SEVERE, null, ex);
                asyncResponse.resume((Throwable)ex);
            }
        });
    }

    public void onComplete(Throwable throwable) {
        if (throwable == null) {
            System.out.println("Completed with a response.");
        } else {
            System.out.println("Completed with an unmapped exception.");
        }
    }
}

