/*
 * Decompiled with CFR 0.152.
 */
package jakarta.nosql.mapping.document;

import jakarta.nosql.document.DocumentDeleteQuery;
import jakarta.nosql.document.DocumentQuery;
import jakarta.nosql.mapping.PreparedStatementAsync;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface DocumentTemplateAsync {
    public <T> void insert(T var1);

    public <T> void insert(T var1, Duration var2);

    default public <T> void insert(Iterable<T> entities) {
        Objects.requireNonNull(entities, "entities is required");
        StreamSupport.stream(entities.spliterator(), false).forEach(this::insert);
    }

    default public <T> void insert(Iterable<T> entities, Duration ttl) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(ttl, "ttl is required");
        StreamSupport.stream(entities.spliterator(), false).forEach(d -> this.insert(d, ttl));
    }

    public <T> void insert(T var1, Consumer<T> var2);

    public <T> void insert(T var1, Duration var2, Consumer<T> var3);

    public <T> void update(T var1, Consumer<T> var2);

    public <T> void update(T var1);

    default public <T> void update(Iterable<T> entities) {
        Objects.requireNonNull(entities, "entities is required");
        StreamSupport.stream(entities.spliterator(), false).forEach(this::update);
    }

    public void delete(DocumentDeleteQuery var1);

    public void delete(DocumentDeleteQuery var1, Consumer<Void> var2);

    public <T> void select(DocumentQuery var1, Consumer<Stream<T>> var2);

    public <T> void query(String var1, Consumer<Stream<T>> var2);

    public <T> void singleResult(String var1, Consumer<Optional<T>> var2);

    public PreparedStatementAsync prepare(String var1);

    public <T, K> void find(Class<T> var1, K var2, Consumer<Optional<T>> var3);

    public <T, K> void delete(Class<T> var1, K var2, Consumer<Void> var3);

    public <T, K> void delete(Class<T> var1, K var2);

    public void count(String var1, Consumer<Long> var2);

    public <T> void count(Class<T> var1, Consumer<Long> var2);

    public <T> void singleResult(DocumentQuery var1, Consumer<Optional<T>> var2);
}

