/*
 * Decompiled with CFR 0.152.
 */
package jakarta.nosql.query;

import jakarta.nosql.ServiceLoaderProvider;
import jakarta.nosql.Sort;
import jakarta.nosql.query.Query;
import jakarta.nosql.query.Where;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public interface SelectQuery
extends Query {
    public List<String> getFields();

    public String getEntity();

    public Optional<Where> getWhere();

    public long getSkip();

    public long getLimit();

    public List<Sort> getOrderBy();

    public static SelectQuery parse(String query) {
        Objects.requireNonNull(query, "query is required");
        return (SelectQuery)((SelectQueryProvider)ServiceLoaderProvider.get(SelectQueryProvider.class)).apply(query);
    }

    public static interface SelectQueryProvider
    extends Function<String, SelectQuery> {
    }
}

