/*
 * Decompiled with CFR 0.152.
 */
package jakarta.nosql.keyvalue;

import jakarta.nosql.ServiceLoaderProvider;
import jakarta.nosql.Value;
import jakarta.nosql.keyvalue.KeyValueEntity;
import jakarta.nosql.keyvalue.KeyValuePreparedStatement;
import jakarta.nosql.keyvalue.KeyValueQueryParser;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public interface BucketManager
extends AutoCloseable {
    public <K, V> void put(K var1, V var2);

    public void put(KeyValueEntity var1);

    public void put(KeyValueEntity var1, Duration var2);

    public void put(Iterable<KeyValueEntity> var1);

    public void put(Iterable<KeyValueEntity> var1, Duration var2);

    public <K> Optional<Value> get(K var1);

    public <K> Iterable<Value> get(Iterable<K> var1);

    public <K> void delete(K var1);

    public <K> void delete(Iterable<K> var1);

    default public Stream<Value> query(String query) {
        Objects.requireNonNull(query, "query is required");
        KeyValueQueryParser parser = (KeyValueQueryParser)ServiceLoaderProvider.get(KeyValueQueryParser.class);
        return parser.query(query, this);
    }

    default public KeyValuePreparedStatement prepare(String query) {
        Objects.requireNonNull(query, "query is required");
        KeyValueQueryParser parser = (KeyValueQueryParser)ServiceLoaderProvider.get(KeyValueQueryParser.class);
        return parser.prepare(query, this);
    }

    @Override
    public void close();
}

