/*
 * Decompiled with CFR 0.152.
 */
package jakarta.nosql.document;

import jakarta.nosql.ServiceLoaderProvider;
import jakarta.nosql.Sort;
import jakarta.nosql.document.DocumentCondition;
import jakarta.nosql.document.DocumentEntity;
import jakarta.nosql.document.DocumentManager;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public interface DocumentQuery {
    public long getLimit();

    public long getSkip();

    public String getDocumentCollection();

    public Optional<DocumentCondition> getCondition();

    public List<Sort> getSorts();

    public List<String> getDocuments();

    public static DocumentSelect select(String ... documents) {
        return (DocumentSelect)((DocumentSelectProvider)ServiceLoaderProvider.get(DocumentSelectProvider.class, () -> ServiceLoader.load(DocumentSelectProvider.class))).apply(documents);
    }

    public static DocumentSelect select() {
        return (DocumentSelect)((DocumentSelectProvider)ServiceLoaderProvider.get(DocumentSelectProvider.class, () -> ServiceLoader.load(DocumentSelectProvider.class))).get();
    }

    public static DocumentQueryBuilder builder() {
        return (DocumentQueryBuilder)((DocumentQueryBuilderProvider)ServiceLoaderProvider.get(DocumentQueryBuilderProvider.class, () -> ServiceLoader.load(DocumentQueryBuilderProvider.class))).get();
    }

    public static DocumentQueryBuilder builder(String ... documents) {
        return (DocumentQueryBuilder)((DocumentQueryBuilderProvider)ServiceLoaderProvider.get(DocumentQueryBuilderProvider.class, () -> ServiceLoader.load(DocumentQueryBuilderProvider.class))).apply(documents);
    }

    public static interface DocumentQueryBuilder {
        public DocumentQueryBuilder select(String var1);

        public DocumentQueryBuilder select(String ... var1);

        public DocumentQueryBuilder sort(Sort var1);

        public DocumentQueryBuilder sort(Sort ... var1);

        public DocumentQueryBuilder from(String var1);

        public DocumentQueryBuilder where(DocumentCondition var1);

        public DocumentQueryBuilder skip(long var1);

        public DocumentQueryBuilder limit(long var1);

        public DocumentQuery build();

        public Stream<DocumentEntity> getResult(DocumentManager var1);

        public Optional<DocumentEntity> getSingleResult(DocumentManager var1);
    }

    public static interface DocumentQueryBuild {
        public DocumentQuery build();

        public Stream<DocumentEntity> getResult(DocumentManager var1);

        public Optional<DocumentEntity> getSingleResult(DocumentManager var1);
    }

    public static interface DocumentOrder {
        public DocumentNameOrder asc();

        public DocumentNameOrder desc();
    }

    public static interface DocumentWhere
    extends DocumentQueryBuild {
        public DocumentNameCondition and(String var1);

        public DocumentNameCondition or(String var1);

        public DocumentSkip skip(long var1);

        public DocumentLimit limit(long var1);

        public DocumentOrder orderBy(String var1);
    }

    public static interface DocumentSkip
    extends DocumentQueryBuild {
        public DocumentLimit limit(long var1);
    }

    public static interface DocumentSelect {
        public DocumentFrom from(String var1);
    }

    public static interface DocumentNotCondition
    extends DocumentNameCondition {
    }

    public static interface DocumentNameOrder
    extends DocumentQueryBuild {
        public DocumentOrder orderBy(String var1);

        public DocumentSkip skip(long var1);

        public DocumentLimit limit(long var1);
    }

    public static interface DocumentNameCondition {
        public <T> DocumentWhere eq(T var1);

        public DocumentWhere like(String var1);

        public <T> DocumentWhere gt(T var1);

        public <T> DocumentWhere gte(T var1);

        public <T> DocumentWhere lt(T var1);

        public <T> DocumentWhere lte(T var1);

        public <T> DocumentWhere between(T var1, T var2);

        public <T> DocumentWhere in(Iterable<T> var1);

        public DocumentNotCondition not();
    }

    public static interface DocumentLimit
    extends DocumentQueryBuild {
        public DocumentSkip skip(long var1);
    }

    public static interface DocumentQueryBuilderProvider
    extends Function<String[], DocumentQueryBuilder>,
    Supplier<DocumentQueryBuilder> {
    }

    public static interface DocumentSelectProvider
    extends Function<String[], DocumentSelect>,
    Supplier<DocumentSelect> {
    }

    public static interface DocumentFrom
    extends DocumentQueryBuild {
        public DocumentNameCondition where(String var1);

        public DocumentSkip skip(long var1);

        public DocumentLimit limit(long var1);

        public DocumentOrder orderBy(String var1);
    }
}

