/*
 * Decompiled with CFR 0.152.
 */
package jakarta.nosql.document;

import jakarta.nosql.NonUniqueResultException;
import jakarta.nosql.ServiceLoaderProvider;
import jakarta.nosql.document.DocumentDeleteQuery;
import jakarta.nosql.document.DocumentEntity;
import jakarta.nosql.document.DocumentObserverParser;
import jakarta.nosql.document.DocumentPreparedStatement;
import jakarta.nosql.document.DocumentQuery;
import jakarta.nosql.document.DocumentQueryParser;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Stream;

public interface DocumentManager
extends AutoCloseable {
    public String getName();

    public DocumentEntity insert(DocumentEntity var1);

    public DocumentEntity insert(DocumentEntity var1, Duration var2);

    public Iterable<DocumentEntity> insert(Iterable<DocumentEntity> var1);

    public Iterable<DocumentEntity> insert(Iterable<DocumentEntity> var1, Duration var2);

    public DocumentEntity update(DocumentEntity var1);

    public Iterable<DocumentEntity> update(Iterable<DocumentEntity> var1);

    public void delete(DocumentDeleteQuery var1);

    public Stream<DocumentEntity> select(DocumentQuery var1);

    default public Stream<DocumentEntity> query(String query) {
        Objects.requireNonNull(query, "query is required");
        DocumentQueryParser parser = (DocumentQueryParser)ServiceLoaderProvider.get(DocumentQueryParser.class, () -> ServiceLoader.load(DocumentQueryParser.class));
        return parser.query(query, this, DocumentObserverParser.EMPTY);
    }

    default public DocumentPreparedStatement prepare(String query) {
        Objects.requireNonNull(query, "query is required");
        DocumentQueryParser parser = (DocumentQueryParser)ServiceLoaderProvider.get(DocumentQueryParser.class, () -> ServiceLoader.load(DocumentQueryParser.class));
        return parser.prepare(query, this, DocumentObserverParser.EMPTY);
    }

    default public Optional<DocumentEntity> singleResult(DocumentQuery query) {
        Objects.requireNonNull(query, "query is required");
        Stream<DocumentEntity> entities = this.select(query);
        Iterator iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        DocumentEntity entity = (DocumentEntity)iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(entity);
        }
        throw new NonUniqueResultException("The select returns more than one entity, select: " + query);
    }

    public long count(String var1);

    @Override
    public void close();
}

