/*
 * Decompiled with CFR 0.152.
 */
package jakarta.nosql.document;

import jakarta.nosql.ServiceLoaderProvider;
import jakarta.nosql.TypeSupplier;
import jakarta.nosql.Value;
import jakarta.nosql.document.Document;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;

public interface DocumentEntity {
    public static DocumentEntity of(String name) {
        return (DocumentEntity)((DocumentEntityProvider)ServiceLoaderProvider.get(DocumentEntityProvider.class, () -> ServiceLoader.load(DocumentEntityProvider.class))).apply(name);
    }

    public static DocumentEntity of(String name, List<Document> documents) {
        DocumentEntity entity = (DocumentEntity)((DocumentEntityProvider)ServiceLoaderProvider.get(DocumentEntityProvider.class, () -> ServiceLoader.load(DocumentEntityProvider.class))).apply(name);
        entity.addAll(documents);
        return entity;
    }

    public String getName();

    public boolean remove(String var1);

    public List<Document> getDocuments();

    public void add(Document var1);

    public void add(String var1, Object var2);

    public void add(String var1, Value var2);

    public void addAll(Iterable<Document> var1);

    public Optional<Document> find(String var1);

    public <T> Optional<T> find(String var1, Class<T> var2);

    public <T> Optional<T> find(String var1, TypeSupplier<T> var2);

    public int size();

    public boolean isEmpty();

    public DocumentEntity copy();

    public void clear();

    public Set<String> getDocumentNames();

    public Collection<Value> getValues();

    public boolean contains(String var1);

    public Map<String, Object> toMap();

    public static interface DocumentEntityProvider
    extends Function<String, DocumentEntity> {
    }
}

