/*
 * Decompiled with CFR 0.152.
 */
package jakarta.nosql.document;

import jakarta.nosql.Condition;
import jakarta.nosql.ServiceLoaderProvider;
import jakarta.nosql.document.Document;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.BiFunction;

public interface DocumentCondition {
    public Document getDocument();

    public Condition getCondition();

    public DocumentCondition and(DocumentCondition var1);

    public DocumentCondition negate();

    public DocumentCondition or(DocumentCondition var1);

    public static DocumentCondition eq(Document document) {
        return (DocumentCondition)((DocumentConditionProvider)ServiceLoaderProvider.get(DocumentConditionProvider.class, () -> ServiceLoader.load(DocumentConditionProvider.class))).apply(document, Condition.EQUALS);
    }

    public static DocumentCondition eq(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return (DocumentCondition)((DocumentConditionProvider)ServiceLoaderProvider.get(DocumentConditionProvider.class, () -> ServiceLoader.load(DocumentConditionProvider.class))).apply(Document.of(name, value), Condition.EQUALS);
    }

    public static DocumentCondition gt(Document document) {
        return (DocumentCondition)((DocumentConditionProvider)ServiceLoaderProvider.get(DocumentConditionProvider.class, () -> ServiceLoader.load(DocumentConditionProvider.class))).apply(document, Condition.GREATER_THAN);
    }

    public static DocumentCondition gt(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return (DocumentCondition)((DocumentConditionProvider)ServiceLoaderProvider.get(DocumentConditionProvider.class, () -> ServiceLoader.load(DocumentConditionProvider.class))).apply(Document.of(name, value), Condition.GREATER_THAN);
    }

    public static DocumentCondition gte(Document document) {
        return (DocumentCondition)((DocumentConditionProvider)ServiceLoaderProvider.get(DocumentConditionProvider.class, () -> ServiceLoader.load(DocumentConditionProvider.class))).apply(document, Condition.GREATER_EQUALS_THAN);
    }

    public static DocumentCondition gte(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return (DocumentCondition)((DocumentConditionProvider)ServiceLoaderProvider.get(DocumentConditionProvider.class, () -> ServiceLoader.load(DocumentConditionProvider.class))).apply(Document.of(name, value), Condition.GREATER_EQUALS_THAN);
    }

    public static DocumentCondition lt(Document document) {
        return (DocumentCondition)((DocumentConditionProvider)ServiceLoaderProvider.get(DocumentConditionProvider.class, () -> ServiceLoader.load(DocumentConditionProvider.class))).apply(document, Condition.LESSER_THAN);
    }

    public static DocumentCondition lt(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return (DocumentCondition)((DocumentConditionProvider)ServiceLoaderProvider.get(DocumentConditionProvider.class, () -> ServiceLoader.load(DocumentConditionProvider.class))).apply(Document.of(name, value), Condition.LESSER_THAN);
    }

    public static DocumentCondition lte(Document document) {
        return (DocumentCondition)((DocumentConditionProvider)ServiceLoaderProvider.get(DocumentConditionProvider.class, () -> ServiceLoader.load(DocumentConditionProvider.class))).apply(document, Condition.LESSER_EQUALS_THAN);
    }

    public static DocumentCondition lte(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return (DocumentCondition)((DocumentConditionProvider)ServiceLoaderProvider.get(DocumentConditionProvider.class, () -> ServiceLoader.load(DocumentConditionProvider.class))).apply(Document.of(name, value), Condition.LESSER_EQUALS_THAN);
    }

    public static DocumentCondition in(Document document) {
        return ((DocumentConditionProvider)ServiceLoaderProvider.get(DocumentConditionProvider.class, () -> ServiceLoader.load(DocumentConditionProvider.class))).in(document);
    }

    public static DocumentCondition in(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return ((DocumentConditionProvider)ServiceLoaderProvider.get(DocumentConditionProvider.class, () -> ServiceLoader.load(DocumentConditionProvider.class))).in(Document.of(name, value));
    }

    public static DocumentCondition like(Document document) {
        return (DocumentCondition)((DocumentConditionProvider)ServiceLoaderProvider.get(DocumentConditionProvider.class, () -> ServiceLoader.load(DocumentConditionProvider.class))).apply(document, Condition.LIKE);
    }

    public static DocumentCondition like(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return (DocumentCondition)((DocumentConditionProvider)ServiceLoaderProvider.get(DocumentConditionProvider.class, () -> ServiceLoader.load(DocumentConditionProvider.class))).apply(Document.of(name, value), Condition.LIKE);
    }

    public static DocumentCondition between(Document document) {
        return ((DocumentConditionProvider)ServiceLoaderProvider.get(DocumentConditionProvider.class, () -> ServiceLoader.load(DocumentConditionProvider.class))).between(document);
    }

    public static DocumentCondition not(DocumentCondition condition) {
        Objects.requireNonNull(condition, "condition is required");
        return condition.negate();
    }

    public static DocumentCondition between(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return ((DocumentConditionProvider)ServiceLoaderProvider.get(DocumentConditionProvider.class, () -> ServiceLoader.load(DocumentConditionProvider.class))).between(Document.of(name, value));
    }

    public static DocumentCondition and(DocumentCondition ... conditions) {
        return ((DocumentConditionProvider)ServiceLoaderProvider.get(DocumentConditionProvider.class, () -> ServiceLoader.load(DocumentConditionProvider.class))).and(conditions);
    }

    public static DocumentCondition or(DocumentCondition ... conditions) {
        return ((DocumentConditionProvider)ServiceLoaderProvider.get(DocumentConditionProvider.class, () -> ServiceLoader.load(DocumentConditionProvider.class))).or(conditions);
    }

    public static interface DocumentConditionProvider
    extends BiFunction<Document, Condition, DocumentCondition> {
        public DocumentCondition between(Document var1);

        public DocumentCondition and(DocumentCondition ... var1);

        public DocumentCondition or(DocumentCondition ... var1);

        public DocumentCondition in(Document var1);
    }
}

