/*
 * Decompiled with CFR 0.152.
 */
package jakarta.nosql.document;

import jakarta.nosql.NonUniqueResultException;
import jakarta.nosql.ServiceLoaderProvider;
import jakarta.nosql.document.DocumentDeleteQuery;
import jakarta.nosql.document.DocumentEntity;
import jakarta.nosql.document.DocumentObserverParser;
import jakarta.nosql.document.DocumentPreparedStatementAsync;
import jakarta.nosql.document.DocumentQuery;
import jakarta.nosql.document.DocumentQueryParserAsync;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;

public interface DocumentCollectionManagerAsync
extends AutoCloseable {
    public void insert(DocumentEntity var1);

    public void insert(DocumentEntity var1, Duration var2);

    public void insert(Iterable<DocumentEntity> var1);

    public void insert(Iterable<DocumentEntity> var1, Duration var2);

    public void insert(DocumentEntity var1, Consumer<DocumentEntity> var2);

    public void insert(DocumentEntity var1, Duration var2, Consumer<DocumentEntity> var3);

    public void update(DocumentEntity var1);

    public void update(Iterable<DocumentEntity> var1);

    public void update(DocumentEntity var1, Consumer<DocumentEntity> var2);

    public void delete(DocumentDeleteQuery var1);

    public void delete(DocumentDeleteQuery var1, Consumer<Void> var2);

    public void select(DocumentQuery var1, Consumer<Stream<DocumentEntity>> var2);

    default public void query(String query, Consumer<Stream<DocumentEntity>> callBack) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(callBack, "callBack is required");
        DocumentQueryParserAsync parser = (DocumentQueryParserAsync)ServiceLoaderProvider.get(DocumentQueryParserAsync.class);
        parser.query(query, this, callBack, DocumentObserverParser.EMPTY);
    }

    default public DocumentPreparedStatementAsync prepare(String query) {
        Objects.requireNonNull(query, "query is required");
        DocumentQueryParserAsync parser = (DocumentQueryParserAsync)ServiceLoaderProvider.get(DocumentQueryParserAsync.class);
        return parser.prepare(query, this, DocumentObserverParser.EMPTY);
    }

    default public void singleResult(DocumentQuery query, Consumer<Optional<DocumentEntity>> callBack) {
        Objects.requireNonNull(query, "query is required");
        this.select(query, entities -> {
            Iterator iterator = entities.iterator();
            if (!iterator.hasNext()) {
                callBack.accept(Optional.empty());
                return;
            }
            DocumentEntity entity = (DocumentEntity)iterator.next();
            if (!iterator.hasNext()) {
                callBack.accept(Optional.of(entity));
                return;
            }
            throw new NonUniqueResultException("The select returns more than one entity, select: " + query);
        });
    }

    public void count(String var1, Consumer<Long> var2);

    @Override
    public void close();
}

