/*
 * Decompiled with CFR 0.152.
 */
package jakarta.nosql;

import jakarta.nosql.NonUniqueResultException;
import jakarta.nosql.ProviderNotFoundException;
import jakarta.nosql.ServiceLoaderSort;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class ServiceLoaderProvider {
    private static final Map<Class<?>, Object> CACHE = new WeakHashMap();

    private ServiceLoaderProvider() {
    }

    private static <T> T getSupplier(Class<T> supplier) {
        Objects.requireNonNull(supplier, "supplier is required");
        Object value = CACHE.get(supplier);
        if (value == null) {
            return ServiceLoaderProvider.load(supplier);
        }
        return (T)value;
    }

    public static <T> T get(Class<T> supplier) {
        return ServiceLoaderProvider.getSupplier(Objects.requireNonNull(supplier, "supplier is required"));
    }

    public static <T> T getUnique(Class<T> supplier) {
        return ServiceLoaderProvider.getUniqueSupplier(supplier, null);
    }

    public static <T> T getUnique(Class<T> supplier, Predicate<Object> predicate) {
        return ServiceLoaderProvider.getUniqueSupplier(supplier, predicate);
    }

    public static <T, I extends T> I getUnique(Class<T> supplier, Class<I> supplierImplementation) {
        Objects.requireNonNull(supplierImplementation, "supplierImplementation is required");
        Predicate<Object> predicate = p -> p.getClass().equals(supplierImplementation);
        return (I)ServiceLoaderProvider.getUniqueSupplier(supplier, predicate);
    }

    public static <T> Stream<Object> getSupplierStream(Class<T> supplier) {
        return StreamSupport.stream(ServiceLoader.load(supplier).spliterator(), false).map(ServiceLoaderSort::of).sorted().map(ServiceLoaderSort::get);
    }

    private static <T> T getUniqueSupplier(Class<T> supplier, Predicate<Object> predicate) {
        List suppliers;
        Stream<Object> stream = ServiceLoaderProvider.getSupplierStream(Objects.requireNonNull(supplier, "supplier is required"));
        if (predicate != null) {
            stream = stream.filter(predicate);
        }
        if ((suppliers = stream.collect(Collectors.toList())).size() == 1) {
            return suppliers.get(0);
        }
        if (suppliers.isEmpty()) {
            throw new ProviderNotFoundException(supplier);
        }
        throw new NonUniqueResultException("There is more than one supplier of the type: " + supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T load(Class<T> supplier) {
        Class clazz = supplier;
        synchronized (clazz) {
            Object result = ServiceLoaderProvider.getSupplierStream(supplier).findFirst().orElseThrow(() -> new ProviderNotFoundException(supplier));
            CACHE.put(supplier, result);
            return (T)result;
        }
    }
}

