/*
 * Decompiled with CFR 0.152.
 */
package jakarta.nosql;

import java.util.Arrays;
import java.util.Objects;

public enum Condition {
    EQUALS,
    GREATER_THAN,
    GREATER_EQUALS_THAN,
    LESSER_THAN,
    LESSER_EQUALS_THAN,
    IN,
    LIKE,
    AND,
    OR,
    NOT,
    BETWEEN;


    public String getNameField() {
        return '_' + this.name();
    }

    public static Condition parse(String condition) {
        Objects.requireNonNull(condition, "condition is required");
        return Arrays.stream(Condition.values()).filter(c -> c.getNameField().equals(condition)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("The condition %s is not found", condition)));
    }
}

