/*
 * Decompiled with CFR 0.152.
 */
package jakarta.nosql;

import jakarta.nosql.ValueReader;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public final class ValueReaderDecorator
implements ValueReader {
    private static final ValueReaderDecorator INSTANCE = new ValueReaderDecorator();
    private final List<ValueReader> readers = new ArrayList<ValueReader>();

    public ValueReaderDecorator() {
        ServiceLoader.load(ValueReader.class).forEach(this.readers::add);
    }

    public static ValueReaderDecorator getInstance() {
        return INSTANCE;
    }

    public boolean isCompatible(Class clazz) {
        return this.readers.stream().anyMatch(r -> r.isCompatible(clazz));
    }

    @Override
    public <T> T read(Class<T> clazz, Object value) {
        if (clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        ValueReader valueReader = this.readers.stream().filter(r -> r.isCompatible(clazz)).findFirst().orElseThrow(() -> new UnsupportedOperationException("The type " + clazz + " is not supported yet"));
        return valueReader.read(clazz, value);
    }

    public String toString() {
        return "ValueReaderDecorator{readers=" + this.readers + '}';
    }
}

