/*
 * Decompiled with CFR 0.152.
 */
package jakarta.nosql;

import jakarta.nosql.TypeReferenceReader;
import jakarta.nosql.TypeSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public final class TypeReferenceReaderDecorator
implements TypeReferenceReader {
    private static final TypeReferenceReaderDecorator INSTANCE = new TypeReferenceReaderDecorator();
    private final List<TypeReferenceReader> readers = new ArrayList<TypeReferenceReader>();

    public TypeReferenceReaderDecorator() {
        ServiceLoader.load(TypeReferenceReader.class).forEach(this.readers::add);
    }

    public static TypeReferenceReaderDecorator getInstance() {
        return INSTANCE;
    }

    @Override
    public <T> boolean isCompatible(TypeSupplier<T> type) {
        return this.readers.stream().anyMatch(r -> r.isCompatible(type));
    }

    @Override
    public <T> T convert(TypeSupplier<T> typeReference, Object value) {
        TypeReferenceReader valueReader = this.readers.stream().filter(r -> r.isCompatible(typeReference)).findFirst().orElseThrow(() -> new UnsupportedOperationException("The type " + typeReference + " is not supported yet"));
        return valueReader.convert(typeReference, value);
    }

    public String toString() {
        return "TypeReferenceReaderDecorator{readers=" + this.readers + '}';
    }
}

