/*
 * Decompiled with CFR 0.152.
 */
package jakarta.nosql;

import jakarta.nosql.ServiceLoaderProvider;
import jakarta.nosql.SortType;
import java.util.function.BiFunction;

public interface Sort {
    public String getName();

    public SortType getType();

    public static Sort of(String name, SortType type) {
        return (Sort)ServiceLoaderProvider.get(SortProvider.class).apply(name, type);
    }

    public static Sort asc(String name) {
        return Sort.of(name, SortType.ASC);
    }

    public static Sort desc(String name) {
        return Sort.of(name, SortType.DESC);
    }

    public static interface SortProvider
    extends BiFunction<String, SortType, Sort> {
    }
}

